% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperFunctions.R
\name{ExtractExperimentData}
\alias{ExtractExperimentData}
\title{ExtractExperimentData}
\usage{
ExtractExperimentData(
  DataSet,
  ExperimentNames,
  idvar = "ParticipantID",
  timevar = "Period",
  ConvertToWide = TRUE
)
}
\arguments{
\item{DataSet}{This is a tibble holding the data for each crossover experiment in a family (a family can include only one experiment).}

\item{ExperimentNames}{This is a list with the full names of each experiment.}

\item{idvar}{This is the name of the column that contains the data for specific participants. It is only assumed to be unique within an experiment (default idvar='ParticipantID').}

\item{timevar}{This is the name of the table column that defines which data was collected in a specific time period. This function assumes that there are only two time periods (default timevar='Period').}

\item{ConvertToWide}{This determine whether the function converts the data to the wide format (default ConvertToWide=TRUE).}
}
\value{
A list with an entry for the data for each experiment. If ConvertToWide is TRUE, it returns the data in the wide format otherwise it returns the data as it was read. Within each list item the data is returned as a tibble
#importFrom stats
# importFrom tibble
# importFrom base
}
\description{
This function reads datasets from a defined directory in the reproducer package that hold the results of a family crossover experiments in the long format. It converts the data to the wide format if required.
}
\examples{
ExperimentNames <- c("EUBAS", "R1UCLM", "R2UCLM", "R3UCLM")
Metrics <- c("Comprehension", "Modification")
Groups <- c("A", "B", "C", "D")
Type <- c(rep("4G", 4))
StudyID <- "S2"
Control <- "SC"
# Obtain experimental data from each file and put in wide format
dataset2 <- KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM
ReshapedData <- ExtractExperimentData(dataset2,
  ExperimentNames = ExperimentNames,
  idvar = "ParticipantID", timevar = "Period", ConvertToWide = TRUE
)
ReshapedData[[1]]

# A tibble: 24 x 15
# ParticipantID ExperimentID.1 SequenceGroup.1 System.1 Treatment.1 Comprehension.1
# <fct>         <fct>          <fct>           <fct>    <fct>                 <dbl>
#   1 1             EUBAS          A               S1       AM                     0.77
# 2 5             EUBAS          A               S1       AM                     0.61
# 3 9             EUBAS          A               S1       AM                     0.61
# 4 13            EUBAS          A               S1       AM                     0.52
# 5 17            EUBAS          A               S1       AM                     0.43
# 6 21            EUBAS          A               S1       AM                     0.77
# 7 2             EUBAS          B               S1       SC                     0.92
# 8 6             EUBAS          B               S1       SC                     0.63
# 9 10            EUBAS          B               S1       SC                     0.51
# 10 14            EUBAS          B               S1       SC                     0.64
# … with 14 more rows, and 9 more variables: Modification.1 <dbl>, CrossOverID.1 <fct>,
#   ExperimentID.2 <fct>, SequenceGroup.2 <fct>, System.2 <fct>, Treatment.2 <fct>,
#   Comprehension.2 <dbl>, Modification.2 <dbl>, CrossOverID.2 <fct>

}
\author{
Barbara Kitchenham and Lech Madeyski
}
