% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{simulateRandomizedBlockDesignEffectSizes}
\alias{simulateRandomizedBlockDesignEffectSizes}
\title{simulateRandomizedBlockDesignEffectSizes}
\usage{
simulateRandomizedBlockDesignEffectSizes(
  mean,
  sd,
  diff,
  N,
  type = "n",
  alpha = 0.05,
  Blockmean = 0,
  BlockStdAdj = 0,
  StdAdj = 0
)
}
\arguments{
\item{mean}{The default value for all groups which can be changed for the two treatment groups using the parameter diff and for the two block 2 groups using the parameter Blockmean}

\item{sd}{The default spread used for all four groups unless adjusted by the StdAdj. It must be a real value greater than 0.}

\item{diff}{This is added to the parameter mean to obtain the required mean for treatment groups. It can be a real value and can take the value zero.}

\item{N}{this is the number of observations in each group. It must be an integer greater than 3.}

\item{type}{this specifies the underlying distribution used to generate the data. it takes the values "n" for a normal distribution, "l" for lognormal distribution,"g" for a gamma distribution, "lap" for a Laplace distribution.}

\item{alpha}{is the significance level for statistical tests}

\item{Blockmean}{if >0 an adjusment made to both group means in Block 2}

\item{BlockStdAdj}{if >0, an adjustment that can be made to the sd of each group in block 2}

\item{StdAdj}{this specifies the extent of variance instability introduced by the treatment and if >0 will be used to amend the sd parameter for both treatment groups.}
}
\value{
data frame incl. the non-parametric and parametric effect sizes and whether the effect sizes are significant at the 0.05 level.
}
\description{
This simulates one of four distributions, and finds the values of ktau and Cliffs d and their variances. It simulates a randomised blocks experiment with two treatment groups and two control groups each of which being divided into two blocks. By default it assumes equal group sizes but  group spread (standard deviation can be changed, see Stadj). It returns values of both parametric and non=parametric effect sizes and their variance for simulated experiments. It returns the number of times each effect size was signficiant. For the logarithmic distribution it calcates effect sizes based on the log transformed data as well as the raw data.
}
\examples{
set.seed(123)
simulateRandomizedBlockDesignEffectSizes(mean=0,sd=1,diff=.5,N=10,type="n",alpha=0.05,
Blockmean=0.5,BlockStdAdj=0,StdAdj=0)
# A tibble: 1 x 23
#      N  phat phat.var phat.df phat.test phat.pvalue phat.sig     d   vard d.sig   cor   sqse
# ctvar    n1    n2
#  <int> <dbl>    <dbl>   <dbl>     <dbl>       <dbl> <lgl>    <dbl>  <dbl> <lgl> <dbl>  <dbl>
# <dbl> <int> <int>
#1    40  0.79  0.00587    30.2      3.79    0.000681 TRUE      0.58 0.0243 TRUE  0.305 0.0132
# 0.00695    20    20
## … with 8 more variables: sigCVt <lgl>, sigCVn <lgl>, ttest.sig <lgl>, ES <dbl>,
# Variance <dbl>, StdES <dbl>,
#   BlockEffect <dbl>, MedianDiff <dbl>
set.seed(123)
simulateRandomizedBlockDesignEffectSizes(mean=0,sd=1,diff=.5,N=10,type="l",alpha=0.05,
Blockmean=0.5,BlockStdAdj=0,StdAdj=0)
# A tibble: 1 x 27
#      N  phat phat.var phat.df phat.test phat.pvalue phat.sig     d   vard d.sig   cor   sqse
# ctvar    n1    n2
#  <int> <dbl>    <dbl>   <dbl>     <dbl>       <dbl> <lgl>    <dbl>  <dbl> <lgl> <dbl>  <dbl>
# <dbl> <int> <int>
#1    40  0.79  0.00587    30.2      3.79    0.000681 TRUE      0.58 0.0243 TRUE  0.305 0.0132
# 0.00695    20    20
# … with 12 more variables: sigCVt <lgl>, sigCVn <lgl>, ttest.sig <lgl>, ES <dbl>,
# Variance <dbl>, StdES <dbl>,
#   BlockEffect <dbl>, MedianDiff <dbl>, Log.sig <lgl>, ES.Trans <dbl>, StdES.Trans <dbl>,
# VarTrans <dbl>
}
\author{
Barbara Kitchenham and Lech Madeyski
}
