% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{RandomizedBlocksAnalysis}
\alias{RandomizedBlocksAnalysis}
\title{RandomizedBlocksAnalysis}
\usage{
RandomizedBlocksAnalysis(x, con = c(-0.5, 0.5, -0.5, 0.5), alpha = 0.05)
}
\arguments{
\item{x}{the structure holding the data. In list format, for a 2 treatment by J block randomized blocks experiments, there are  2J list elements each one specifying the outcome for a specific block and a specific treatment.}

\item{con}{is a 2J list containing the contrast coefficients that are used to calculate the mean effet size.}

\item{alpha}{default to 0.05 is the Type 1 error level used for the test of significance}
}
\value{
The t-test and its associated metrics (i.e., critical value stansard error and degrees of freedom) and the estimate of the contrast with its upper and lower confidence interval bounds and p-value.
}
\description{
The function performs a heteroscedastic test of a two treatment by J blocks randomized blocks effect size. The data are assumed to be stored in $x$ in list mode, a matrix or a data frame. If in list mode, length(x) is assumed to correspond to the total number of groups. All groups are assumed to be independent. Missing values are automatically removed.
}
\examples{
set.seed(123)
x=list()
x[[1]]=stats::rnorm(10,0,1)
x[[2]]=stats::rnorm(10,0.8,1)
x[[3]]=stats::rnorm(10,0.5,1)
x[[4]]=stats::rnorm(10,1.3,1)
vec=c(-1,1,-1,1)/2
RandomizedBlocksAnalysis(x,con=vec,alpha=0.05)
# $n
# [1] 10 10 10 10
# $test
#      test     crit        se       df
# [1,] 4.432644 2.038622 0.2798104 31.33793
# $psihat
#      psihat  ci.lower ci.upper      p.value
# [1,] 1.2403 0.6698721 1.810728 0.0001062952
# dat=c(x[[1]],x[[2]],x[[3]],x[[4]])
# matx=matrix(dat,nrow=10,ncol=4)
# RandomizedBlocksAnalysis(matx,con=c(-1,1,-1,1)/2,alpha=0.05)
#$n
#[1] 10 10 10 10
#$test
#         test     crit        se       df
#[1,] 4.432644 2.038622 0.2798104 31.33793
#$psihat
#     psihat  ci.lower ci.upper      p.value
#[1,] 1.2403 0.6698721 1.810728 0.0001062952
}
\author{
Barbara Kitchenham and Lech Madeyski
}
