% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperFunctions.R
\name{ConstructLevel1ExperimentRData}
\alias{ConstructLevel1ExperimentRData}
\title{ConstructLevel1ExperimentRData}
\usage{
ConstructLevel1ExperimentRData(
  Data,
  StudyID,
  ExperimentNames,
  Groups,
  Metrics,
  Type,
  Control
)
}
\arguments{
\item{Data}{This is a list parameter each entry in the list holds the data for each participant in a 2-group or 4-group crossover experiment in the "wide" format. I.e., there is only one entry per participant. The data should have been generated from a long version of the data based on a variable labelled "Period" which is used to define which participant data was collected in the first period of the experiment - see function ExtractLevel1ExperimentRData.}

\item{StudyID}{This holds an identifer used to identify the origin of the experimental data in the output from this function.}

\item{ExperimentNames}{This a list of identifiers used to define each experiment in the output from this function.}

\item{Groups}{This is a list that defined the sequence group identifiers used in the dataset.}

\item{Metrics}{This is a list of of character strings identifying each outcome metric reported in each of the experiments in the set of replicated experiments.}

\item{Type}{this is a list of character strings specifying for each experiment whether the experiment is a 2-group or 4-group experiment}

\item{Control}{this is a character string that defines the control treatment in the experiment.}
}
\value{
R.Data.Table this is a tibble holding information identifying for each metric and sequence group the first time period and second time period variance, the pooled variance, the variance of the difference values and the exact r and pooled r.
}
\description{
This function returns the r value for a 2-group (2G) or 4-Group (4G) Crossover experiment for a group of 1 or more experiments for each sequence group and each outcome metric. For sets of 2 or more experiments, the experiments are assumed to be replicates and to report the same sets of Metrics and have the same Control treatment and use the same squence Group identifiers, but are not necessarily the same Type. We return both the exact r value and the r value based on pooled variances for each sequence group and outcome metric.
}
\examples{
#
ShortExperimentNames=c("E1","E2","E3","E4")
FullExperimentNames=c("EUBAS","R1UCLM","R2UCLM","R3UCLM")
Metrics=c("Comprehension","Modification")
Groups=Groups=c("A","B","C","D")
Type=c(rep("4G",4))
StudyID="S2"
Control="SC"
# Obtain experimental data from each file and put in wide format
dataset2= KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14TOSEM
ReshapedData=ExtractExperimentData(dataset2, ExperimentNames=FullExperimentNames,
  idvar="ParticipantID",timevar="Period",ConvertToWide=TRUE)
# Calculate the correlations for each sequence group and each metric in each experiment
ConstructLevel1ExperimentRData(Data=ReshapedData, StudyID=StudyID,
  ExperimentNames=ShortExperimentNames, Groups=Groups, Metrics=Metrics, Type=Type,
  Control=Control
)
# # A tibble: 32 x 15
# Study Exp   Group Metric Id        n ControlFirst    var1   var2    varp
# <chr> <chr> <chr> <chr>  <chr> <int> <lgl>          <dbl>  <dbl>   <dbl>
#   1 S2    E1    A     Compr… S2E1A     6 FALSE        0.0183  0.0163 0.0173
# 2 S2    E1    B     Compr… S2E1B     6 TRUE         0.0201  0.0326 0.0263
# 3 S2    E1    C     Compr… S2E1C     6 FALSE        0.00370 0.0155 0.00962
# 4 S2    E1    D     Compr… S2E1D     6 TRUE         0.0173  0.0201 0.0187
# 5 S2    E1    A     Modif… S2E1A     6 FALSE        0.0527  0.0383 0.0455
# 6 S2    E1    B     Modif… S2E1B     6 TRUE         0.0185  0.0482 0.0333
# 7 S2    E1    C     Modif… S2E1C     6 FALSE        0.00655 0.0244 0.0155
# 8 S2    E1    D     Modif… S2E1D     6 TRUE         0.0222  0.0266 0.0244
# 9 S2    E2    A     Compr… S2E2A     6 FALSE        0.0194  0.0425 0.0309
# 10 S2    E2    B     Compr… S2E2B     6 TRUE         0.0198  0.0192 0.0195
# # … with 22 more rows, and 5 more variables: ControlVarProp <dbl>,
# #   VarProp <dbl>, vardiff <dbl>, r <dbl>, r.p <dbl>
}
\author{
Barbara Kitchenham and Lech Madeyski
}
