% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reproducer.R
\name{printXTable}
\alias{printXTable}
\title{printXTable}
\usage{
printXTable(data, selectedColumns, tableType = "latex", alignCells, digits,
  caption, label, fontSize, captionPlacement = "bottom", alignHeader)
}
\arguments{
\item{data}{Data structure including columns to be printed.}

\item{selectedColumns}{Columns selected to be printed.}

\item{tableType}{Type of table to produce. Possible values are "latex" or "html". Default value is "latex".}

\item{alignCells}{Defines how to align data cells.}

\item{digits}{Defines the number of decimal points in each column.}

\item{caption}{Caption of the table.}

\item{label}{Label of the table.}

\item{fontSize}{Size of the font used to produce a table.}

\item{captionPlacement}{The caption will be have placed at the bottom of the table if captionPlacement is "bottom" and at the top of the table if it equals "top". Default value is "bottom".}

\item{alignHeader}{Defines how to align column headers of a table.}
}
\value{
A table generated on the fly on a basis of passed data (data, selectedColumns etc.).
}
\description{
print data table using xtable R package
}
\examples{
d <- reproducer::MadeyskiKitchenham.MetaAnalysis.PBRvsCBRorAR
reproducer::printXTable(d, '"Study"', "latex", '"cc"', 0, "C", "L", "tiny", "top", "l")
}
\author{
Lech Madeyski
}

