% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_export}
\alias{repo_export}
\title{Export \code{repo} items to RDS file.}
\usage{
repo_export(repo, name, where = ".", tags = NULL)
}
\arguments{
\item{repo}{An object of class repo.}

\item{name}{Name of the item to export.}

\item{where}{Destination directory}

\item{tags}{List of tags: all items tagged with all the tags in the
list will be exported.}
}
\value{
TRUE on success, FALSE otherwise.
}
\description{
Export \code{repo} items to RDS file.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)
repo$put(1, "item1", "Sample item 1", "export", replace=TRUE)
repo$export("item1", tempdir()) # creates item1.RDS in a tempdir

## wiping temporary repo
unlink(repo_path, TRUE)
}

