## ---- echo = FALSE--------------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = " # "
)
options(width =100)

## -------------------------------------------------------------------------------------------------
d <- data.frame(x = c(1, NA))
print(d)

## ----eval=FALSE-----------------------------------------------------------------------------------
#  d$x_isNA <- is.na(d$x)

## -------------------------------------------------------------------------------------------------
library("dplyr")
packageVersion("dplyr")
d %>% mutate(x_isNA = is.na(x))

## -------------------------------------------------------------------------------------------------
cname <- "x"                            # column we are examining
rname <- paste(cname, "isNA", sep= '_') # where to land results
print(rname)

## ---- eval=FALSE----------------------------------------------------------------------------------
#  d[[rname]] <- is.na(d[[cname]])

## -------------------------------------------------------------------------------------------------
# wrapr::let solution
wrapr::let(alias = list(cname = cname, rname = rname),
            expr  = {
            d %>% mutate(rname = is.na(cname))
            })

