% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config}
\alias{config}
\title{User-Level Configuration of renv}
\description{
Configure different behaviors of \code{renv}.
}
\details{
For a given configuration option:
\enumerate{
\item If an \R option of the form \verb{renv.config.<name>} is available,
then that option's value will be used;
\item If an environment variable of the form \verb{RENV_CONFIG_<NAME>} is available,
then that option's value will be used;
\item Otherwise, the default for that particular configuration value is used.
}

Any periods (\code{.})s in the option name are transformed into underscores (\verb{_})
in the environment variable name, and vice versa. For example, the
configuration option \code{auto.snapshot} could be configured as:
\itemize{
\item \verb{options(renv.config.auto.snapshot = <...>)}
\item \verb{Sys.setenv(RENV_CONFIG_AUTO_SNAPSHOT = <...>)}
}

Note that if both the R option and the environment variable are defined, the
R option will be used instead. Environment variables can be more useful when
you want a particular configuration to be automatically inherited by child
processes; if that behavior is not desired, then the R option may be
preferred.

If you want to set and persist these options across multiple projects, it is
recommended that you set them in your user startup files (e.g. in
\verb{~/.Rprofile} or \verb{~/.Renviron}).
}
\section{Configuration}{


The following \code{renv} configuration options are available:

\describe{
\item{\bold{\code{renv.config.auto.snapshot}}}{Automatically snapshot changes to the project library after a new package is installed?
Defaults to \code{FALSE}.}
\item{\bold{\code{renv.config.bitbucket.host}}}{The default Bitbucket host to be used during package retrieval.
Defaults to \code{"api.bitbucket.org/2.0"}.}
\item{\bold{\code{renv.config.copy.method}}}{The method to use when attempting to copy directories. See \strong{Copy Methods} for more information.
Defaults to \code{"auto"}.}
\item{\bold{\code{renv.config.connect.timeout}}}{The amount of time to spend (in seconds) when attempting to download a file. Only applicable when the \code{curl} downloader is used.
Defaults to \code{20L}.}
\item{\bold{\code{renv.config.connect.retry}}}{The number of times to attempt re-downloading a file, when transient download errors occur. Only applicable when the \code{curl} downloader is used.
Defaults to \code{3L}.}
\item{\bold{\code{renv.config.cache.enabled}}}{Enable the global \code{renv} package cache? When active, \code{renv} will install packages into a global cache, and link or copy packages from the cache into your \R library as appropriate. This can greatly save on disk space and install time when \R packages are shared across multiple projects in the same environment.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.cache.symlinks}}}{Symlink packages from the global \code{renv} package cache into your project library? When \code{TRUE}, \code{renv} will use symlinks (or, on Windows, junction points) to reference packages installed in the cache. Set this to \code{FALSE} if you'd prefer to copy packages from the cache into your project library.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.dependency.errors}}}{Many \code{renv} APIs require the enumeration of your project's \R package dependencies. This option controls how errors that occur during this enumeration are handled. By default, errors are reported but are non-fatal. Set this to \code{"fatal"} to force errors to be fatal, and \code{"ignored"} to ignore errors altogether. See \code{\link[=dependencies]{dependencies()}} for more details.
Defaults to \code{"reported"}.}
\item{\bold{\code{renv.config.external.libraries}}}{A character vector of external libraries, to be used in tandem with your projects. Be careful when using external libraries: it's possible that things can break within a project if the version(s) of packages used in your project library happen to be incompatible with packages in your external libraries; for example, if your project required \verb{xyz 1.0} but \verb{xyz 1.1} was present and loaded from an external library. Can also be an \R function that provides the paths to external libraries. Library paths will be expanded via \code{\link[=.expand_R_libs_env_var]{.expand_R_libs_env_var()}} as necessary.
Defaults to \code{NULL}.}
\item{\bold{\code{renv.config.filebacked.cache}}}{Enable the \code{renv} file-backed cache? When enabled, \code{renv} will cache the contents of files that are read (e.g. DESCRIPTION files) in memory, thereby avoiding re-reading the file contents from the filesystem if the file has not changed. \code{renv} uses the file \code{mtime} to determine if the file has changed; consider disabling this if \code{mtime} is unreliable on your system.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.github.host}}}{The default GitHub host to be used during package retrieval.
Defaults to \code{"api.github.com"}.}
\item{\bold{\code{renv.config.gitlab.host}}}{The default GitLab host to be used during package retrieval.
Defaults to \code{"gitlab.com"}.}
\item{\bold{\code{renv.config.hydrate.libpaths}}}{A character vector of library paths, to be used by \code{\link[=hydrate]{hydrate()}} when attempting to hydrate projects. When empty, the default set of library paths (as documented in \code{?hydrate}) are used instead. See \code{\link[=hydrate]{hydrate()}} for more details.
Defaults to \code{NULL}.}
\item{\bold{\code{renv.config.install.shortcuts}}}{Allow for a set of 'shortcuts' when installing packages with renv? When enabled, if \code{renv} discovers that a package to be installed is already available within the user or site libraries, then it will install a local copy of that package.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.install.staged}}}{DEPRECATED: Please use \code{renv.config.install.transactional} instead.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.install.transactional}}}{Perform a transactional install of packages during install and restore? When enabled, \code{renv} will first install packages into a temporary library, and later copy or move those packages back into the project library only if all packages were successfully downloaded and installed. This can be useful if you'd like to avoid mutating your project library if installation of one or more packages fails.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.install.verbose}}}{Be verbose when installing R packages from sources? When \code{TRUE}, \code{renv} will stream any output generated during package build + installation to the console.
Defaults to \code{FALSE}.}
\item{\bold{\code{renv.config.locking.enabled}}}{Use interprocess locks when invoking methods which might mutate the project library? Enable this to allow multiple processes to use the same \code{renv} project, while minimizing risks relating to concurrent access to the project library. Disable this if you encounter locking issues. Locks are stored as files within the project at \code{renv/lock}; if you need to manually remove a stale lock you can do so via \code{unlink("renv/lock", recursive = TRUE)}.
Defaults to \code{FALSE}.}
\item{\bold{\code{renv.config.mran.enabled}}}{Attempt to download binaries from \href{https://mran.microsoft.com/}{MRAN} during restore? See \code{vignette("mran", package = "renv")} for more details.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.repos.override}}}{Override the R package repositories used during \code{\link[=restore]{restore()}}? Primarily useful for deployment / continuous integration, where you might want to enforce the usage of some set of repositories over what is defined in \code{renv.lock} or otherwise set by the R session.
Defaults to \code{NULL}.}
\item{\bold{\code{renv.config.rspm.enabled}}}{Boolean; enable RSPM integration for \code{renv} projects? When \code{TRUE}, \code{renv} will attempt to transform the repository URLs used by RSPM into binary URLs as appropriate for the current platform. Set this to \code{FALSE} if you'd like to continue using source-only RSPM URLs, or if you find that \code{renv} is improperly transforming your repository URLs.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.sandbox.enabled}}}{Enable sandboxing for \code{renv} projects? When active, \code{renv} will attempt to sandbox the system library, preventing non-system packages installed in the system library from becoming available in \code{renv} projects. (That is, only packages with priority \code{"base"} or \code{"recommended"}, as reported by \code{installed.packages()}, are made available.)
Sandboxing is done by linking or copying system packages into a separate library path, and then instructing R to use that library path as the system library path. In some environments, this action can take a large amount of time -- in such a case, you may want to disable the renv sandbox.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.shims.enabled}}}{Should \code{renv} shims be installed on package load? When enabled, \code{renv} will install its own shims over the functions \code{install.packages()}, \code{update.packages()} and \code{remove.packages()}, delegating these functions to \code{\link[=install]{install()}}, \code{\link[=update]{update()}} and \code{\link[=remove]{remove()}} as appropriate.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.snapshot.validate}}}{Validate \R package dependencies when calling snapshot? When \code{TRUE}, \code{renv} will attempt to diagnose potential issues in the project library before creating \code{renv.lock} -- for example, if a package installed in the project library depends on a package which is not currently installed.
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.startup.quiet}}}{Be quiet during startup? When set, \code{renv} will not display the typical \verb{Project <path> loaded. [renv <version>]} banner on startup.
Defaults to \code{NULL}.}
\item{\bold{\code{renv.config.synchronized.check}}}{Check that the project library is synchronized with the lockfile on load?
Defaults to \code{TRUE}.}
\item{\bold{\code{renv.config.updates.check}}}{Check for package updates when the session is initialized? This can be useful if you'd like to ensure that your project lockfile remains up-to-date with packages as they are released on CRAN.
Defaults to \code{FALSE}.}
\item{\bold{\code{renv.config.updates.parallel}}}{Check for package updates in parallel? This can be useful when a large number of packages installed from non-CRAN remotes are installed, as these packages can then be checked for updates in parallel.
Defaults to \code{2L}.}
\item{\bold{\code{renv.config.user.library}}}{Include the user library on the library paths for your projects? Note that this risks breaking project encapsulation and is not recommended for projects which you intend to share or collaborate on with other users. See also the caveats for the \code{renv.config.external.libraries} option.
Defaults to \code{FALSE}.}
\item{\bold{\code{renv.config.user.profile}}}{Load the user R profile (typically located at \verb{~/.Rprofile}) when \code{renv} is loaded? Consider disabling this if you require extra encapsulation in your projects; e.g. if your \code{.Rprofile} attempts to load packages that you might not install in your projects. Defaults to \code{FALSE}.}
}
}

\section{Copy Methods}{


If you find that \code{renv} is unable to copy some directories in your
environment, you may want to try setting the \code{copy.method} option. By
default, \code{renv} will try to choose a system tool that is likely to succeed in
copying files on your system -- \code{robocopy} on Windows, and \code{cp} on Unix.
\code{renv} will also instruct these tools to preserve timestamps and attributes
when copying files. However, you can select a different method as
appropriate.

The following methods are supported:

\tabular{ll}{
\code{auto}     \tab Use \code{robocopy} on Windows, and \code{cp} on Unix-alikes. \cr
\code{R}        \tab Use \R's built-in \code{file.copy()} function. \cr
\code{cp}       \tab Use \code{cp} to copy files. \cr
\code{robocopy} \tab Use \code{robocopy} to copy files. (Only available on Windows.) \cr
\code{rsync}    \tab Use \code{rsync} to copy files. \cr
}

You can also provide a custom copy method if required; e.g.\preformatted{options(renv.config.copy.method = function(src, dst) \{
  # copy a file from 'src' to 'dst'
\})
}

Note that \code{renv} will always first attempt to copy a directory first to a
temporary path within the target folder, and then rename that temporary path
to the final target destination. This helps avoid issues where a failed
attempt to copy a directory could leave a half-copied directory behind
in the final location.
}

\section{Project-Local Settings}{


For settings that should persist alongside a particular project, the
various settings available in \link{settings} can be used.
}

\examples{

# disable automatic snapshots
options(renv.config.auto.snapshot = FALSE)

# disable with environment variable
Sys.setenv(RENV_CONFIG_AUTO_SNAPSHOT = FALSE)

}
