% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_lm_slopes.R
\name{nice_lm_slopes}
\alias{nice_lm_slopes}
\title{Nice formatting of simple slopes for lm models}
\usage{
nice_lm_slopes(
  model,
  predictor,
  moderator,
  b.label = "b",
  mod.id = TRUE,
  ci.alternative = "two.sided",
  ...
)
}
\arguments{
\item{model}{The model to be formatted.}

\item{predictor}{The independent variable.}

\item{moderator}{The moderating variable.}

\item{b.label}{What to rename the default "b" column (e.g.,
to capital B if using standardized data for it to be converted
to the Greek beta symbol in the \code{nice_table} function).}

\item{mod.id}{Logical. Whether to display the model number,
when there is more than one model.}

\item{ci.alternative}{Alternative for the confidence interval
of the sr2. It can be either "two.sided (the default in this
package), "greater", or "less".}

\item{...}{Further arguments to be passed to the \code{lm}
function for the models.}
}
\value{
A formatted dataframe of the simple slopes of the specified lm model,
with DV, levels of IV, degrees of freedom, regression coefficient,
t-value, p-value, and the effect size, the semi-partial correlation
squared, and its confidence interval.
}
\description{
Extracts simple slopes from \code{lm} model
object and format for a publication-ready format.
}
\details{
The effect size, sr2 (semi-partial correlation squared, also
known as delta R2), is computed through \link[effectsize:r2_semipartial]{effectsize::r2_semipartial}.
Please read the documentation for that function, especially regarding
the interpretation of the confidence interval. In \code{rempsyc}, instead
of using the default one-sided alternative ("greater"), we use the
two-sided alternative.
}
\examples{
# Make and format model
model <- lm(mpg ~ gear * wt, mtcars)
nice_lm_slopes(model, predictor = "gear", moderator = "wt")

# Make and format multiple models
model2 <- lm(qsec ~ gear * wt, mtcars)
my.models <- list(model, model2)
nice_lm_slopes(my.models, predictor = "gear", moderator = "wt")

}
\seealso{
Checking for moderation before checking simple slopes:
\code{\link{nice_lm}}, \code{\link{nice_mod}},
\code{\link{nice_slopes}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/moderation}
}
\keyword{interaction}
\keyword{moderation}
\keyword{regression}
