% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_lm.R
\name{nice_lm}
\alias{nice_lm}
\title{Nice formatting of lm models}
\usage{
nice_lm(model, b.label = "b", mod.id = TRUE, ci.alternative = "two.sided", ...)
}
\arguments{
\item{model}{The model to be formatted.}

\item{b.label}{What to rename the default "b" column (e.g.,
to capital B if using standardized data for it to be converted
to the Greek beta symbol in the \code{nice_table} function).}

\item{mod.id}{Logical. Whether to display the model number,
when there is more than one model.}

\item{ci.alternative}{Alternative for the confidence interval
of the sr2. It can be either "two.sided (the default in this
package), "greater", or "less".}

\item{...}{Further arguments to be passed to the
\link[effectsize:r2_semipartial]{effectsize::r2_semipartial} function for the effect size.}
}
\value{
A formatted dataframe of the specified lm model, with DV, IV, degrees
of freedom, regression coefficient, t-value, p-value, and the effect
size, the semi-partial correlation squared, and its confidence interval.
}
\description{
Formats output of \code{lm} model object for a
publication-ready format.
}
\details{
The effect size, sr2 (semi-partial correlation squared, also
known as delta R2), is computed through \link[effectsize:r2_semipartial]{effectsize::r2_semipartial}.
Please read the documentation for that function, especially regarding
the interpretation of the confidence interval. In \code{rempsyc}, instead
of using the default one-sided alternative ("greater"), we use the
two-sided alternative.
}
\examples{
# Make and format model
model <- lm(mpg ~ cyl + wt * hp, mtcars)
nice_lm(model)

# Make and format multiple models
model2 <- lm(qsec ~ disp + drat * carb, mtcars)
my.models <- list(model, model2)
nice_lm(my.models)

}
\seealso{
Checking simple slopes after testing for moderation:
\code{\link{nice_lm_slopes}}, \code{\link{nice_mod}},
\code{\link{nice_slopes}}. Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/moderation}
}
\keyword{interaction}
\keyword{moderation}
\keyword{regression}
