% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcc_client_device.r
\name{rDevices}
\alias{rDevices}
\alias{dev.curc}
\alias{dev.listc}
\alias{dev.nextc}
\alias{dev.prevc}
\alias{dev.offc}
\alias{dev.setc}
\alias{dev.newc}
\alias{dev.sizec}
\title{Local Graphic Devices}
\usage{
dev.curc()

dev.listc()

dev.nextc(which = grDevices::dev.cur())

dev.prevc(which = grDevices::dev.cur())

dev.offc(which = grDevices::dev.cur())

dev.setc(which = grDevices::dev.cur())

dev.newc(..., noRstudioGD = FALSE)

dev.sizec(units = c("in", "cm", "px"))
}
\arguments{
\item{which}{An integer specifying a device number as in \code{grDevices::dev.off()}}

\item{...}{arguments to be passed to the device selected as in
\code{grDevices::dev.new()}}

\item{noRstudioGD}{as in \code{grDevices::dev.new()}}

\item{units}{as in \code{grDevices::dev.size()}}
}
\description{
Functions for controlling graphic device locally when the client of
remote R is on. All these functions are evaluated in local R from within
the remote R prompt.

\code{dev.curc()} locally evals \code{grDevices::dev.cur()}.

\code{dev.listc()} locally evals \code{grDevices::dev.list()}.

\code{dev.nextc()} locally evals \code{grDevices::dev.next()}.

\code{dev.prevc()} locally evals \code{grDevices::dev.prev()}.

\code{dev.offc()} locally evals \code{grDevices::dev.off()}.

\code{dev.setc()} locally evals \code{grDevices::dev.set()}.

\code{dev.newc()} locally eval \code{grDevices::dev.new()}.

\code{dev.sizec()} locally evals \code{grDevices::dev.size()}.
}
\details{
Local Graphic Device Controlling Functions
}
\examples{
\dontrun{
### Prompts are listed to clarify when something is eval'd locally vs
### remotely
> library(remoter, quietly = TRUE)
> client()

remoter> rpng.new(plot(1:5))
remoter> dev.newc(width = 6, height = 4)
remoter> a <- function() plot(iris$Sepal.Length, iris$Petal.Length)
remoter> rpng.new(a, width = 6 * 72, height = 4 * 72)

remoter> dev.curc()
remoter> dev.listc()
remoter> dev.offc()

remoter> q()
>
}

}
\seealso{
\code{\link{rpng}()}
}
