% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{re_match}
\alias{re_match}
\title{Extract Regular Expression Matches Into a Data Frame}
\usage{
re_match(text, pattern, perl = TRUE, ...)
}
\arguments{
\item{text}{Character vector.}

\item{pattern}{A regular expression. See \code{\link[base]{regex}} for more
about regular expressions.}

\item{perl}{logical should perl compatible regular expressions be used?
Defaults to TRUE, setting to FALSE will disable capture groups.}

\item{...}{Additional arguments to pass to \code{\link[base]{regexpr}}.}
}
\value{
A data frame of character vectors: one column per capture
  group, named if the group was named, and additional columns for
  the input text and the first matching (sub)string. Each row
  corresponds to an element in the \code{text} vector.
}
\description{
\code{re_match} wraps \code{\link[base]{regexpr}} and returns the
match results in a convenient data frame. The data frame has one
column for each capture group if \code{perl=TRUE}, and one final columns
called \code{.match} for the matching (sub)string. The columns of the capture
groups are named if the groups themselves are named.
}
\note{
\code{re_match} uses PCRE compatible regular expressions by default
(i.e. \code{perl = TRUE} in \code{\link[base]{regexpr}}).  You can switch
this off but if you do so capture groups will no longer be reported as they
are only supported by PCRE.
}
\examples{
dates <- c("2016-04-20", "1977-08-08", "not a date", "2016",
  "76-03-02", "2012-06-30", "2015-01-21 19:58")
isodate <- "([0-9]{4})-([0-1][0-9])-([0-3][0-9])"
re_match(text = dates, pattern = isodate)

# The same with named groups
isodaten <- "(?<year>[0-9]{4})-(?<month>[0-1][0-9])-(?<day>[0-3][0-9])"
re_match(text = dates, pattern = isodaten)
}
\seealso{
Other tidy regular expression matching: \code{\link{re_exec_all}},
  \code{\link{re_exec}}, \code{\link{re_match_all}}
}
