% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/furcation-class.R
\docType{class}
\name{furcation-class}
\alias{furcation-class}
\alias{furcation}
\title{An S4 class representing the complete furcation pattern around a focal marker.}
\description{
An S4 class representing the complete furcation pattern around a focal marker.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{a list containing for each allele an object of \code{allelefurcation-class}.}

\item{\code{mrk.name}}{the name/identifier of the focal marker.}

\item{\code{position}}{the chromosomal position of the focal marker.}

\item{\code{xlim}}{the range of marker positions.}

\item{\code{nhap}}{the number of haplotypes in the sample.}
}}

\examples{
# copy example files into working directory
make.example.files()
# read first example file
hh <- data2haplohh(hap_file = "example1.hap", map_file = "example1.map", allele_coding = "01")
# remove example files
remove.example.files()
# calculate furcation structure around marker "rs6"
f <- calc_furcation(hh, mrk = "rs6")
# extract left side tree of ancestral allele (which is coded by '0')
f[['0']]@left
# the tree consists of seven nodes, '1' being the root node
# nodes 2 and 3 have the root node as parent, etc.
# the first chromosome is attached as a label node to node 7, etc.
# For comparison, a plot of the complete furcation structure:
plot(f)
}
\seealso{
\code{\link{calc_furcation}}
}
