% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_optim.R
\name{multi_optim}
\alias{multi_optim}
\title{Multiple starts for Regularized Structural Equation Modeling}
\usage{
multi_optim(model, max.try = 10, lambda = 0, LB = -Inf, UB = Inf,
  block = TRUE, full = TRUE, type = "none", optMethod = "default",
  gradFun = "ram", pars_pen = NULL, diff_par = NULL, hessFun = "none",
  tol = 1e-05, solver = FALSE, solver.maxit = 50000, alpha.inc = TRUE,
  step = 0.5, momentum = FALSE, step.ratio = FALSE, verbose = FALSE,
  warm.start = FALSE, Start2 = NULL, nlminb.control = NULL)
}
\arguments{
\item{model}{Lavaan output object. This is a model that was previously
run with any of the lavaan main functions: cfa(), lavaan(), sem(),
or growth(). It also can be from the efaUnrotate() function from
the semTools package. Currently, the parts of the model which cannot
be handled in regsem is the use of multiple group models, missing
other than listwise, thresholds from categorical variable models,
the use of additional estimators other than
ML, most notably WLSMV for categorical variables. Note: the model
does not have to actually run (use do.fit=FALSE), converge etc...
regsem() uses the lavaan object as more of a parser and to get
sample covariance matrix.}

\item{max.try}{number of starts to try before convergence.}

\item{lambda}{Penalty value. Note: higher values will result in additional
convergence issues.}

\item{LB}{lower bound vector. Note: This is very important to specify
when using regularization. It greatly increases the chances of
converging.}

\item{UB}{Upper bound vector}

\item{block}{Whether to use block coordinate descent}

\item{full}{Whether to do full gradient descent or block}

\item{type}{Penalty type. Options include "none", "lasso", "ridge",
"enet" for the elastic net,
"alasso" for the adaptive lasso, "scad, "mcp",
and "diff_lasso". diff_lasso penalizes the discrepency between
parameter estimates and some pre-specified values. The values
to take the deviation from are specified in diff_par.}

\item{optMethod}{Solver to use. Recommended options include "nlminb" and
"optimx". Note: for "optimx", the default method is to use nlminb.
This can be changed in subOpt.}

\item{gradFun}{Gradient function to use. Recommended to use "ram",
which refers to the method specified in von Oertzen & Brick (2014).
The "norm" procedure uses the forward difference method for
calculating the hessian. This is slower and less accurate.}

\item{pars_pen}{Parameter indicators to penalize. If left NULL, by default,
all parameters in the \emph{A} matrix outside of the intercepts are
penalized when lambda > 0 and type != "none".}

\item{diff_par}{Parameter values to deviate from. Only used when
type="diff_lasso".}

\item{hessFun}{Hessian function to use. Recommended to use "ram",
which refers to the method specified in von Oertzen & Brick (2014).
The "norm" procedure uses the forward difference method for
calculating the hessian. This is slower and less accurate.}

\item{tol}{Tolerance for coordinate descent}

\item{solver}{Whether to use solver for coord_desc}

\item{solver.maxit}{Max iterations for solver in coord_desc}

\item{alpha.inc}{Whether alpha should increase for coord_desc}

\item{step}{Step size}

\item{momentum}{Logical for coord_desc}

\item{step.ratio}{Ratio of step size between A and S. Logical}

\item{verbose}{Whether to print iteration number.}

\item{warm.start}{Whether start values are based on previous iteration.
This is not recommended.}

\item{Start2}{Provided starting values. Not required}

\item{nlminb.control}{list of control values to pass to nlminb}
}
\description{
Multiple starts for Regularized Structural Equation Modeling
}
\examples{
\dontrun{
# Note that this is not currently recommend. Use regsem() instead
library(regsem)
HS <- data.frame(scale(HolzingerSwineford1939[,7:15]))
mod <- '
f =~ x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9
'
outt = cfa(mod,HS,meanstructure=TRUE)

fit1 <- multi_optim(outt,max.try=40,
                   lambda=0.1,type="lasso",
                   gradFun="ram")


# growth model
model <- ' i =~ 1*t1 + 1*t2 + 1*t3 + 1*t4
          s =~ 0*t1 + s1*t2 + s2*t3 + 3*t4 '
fit <- growth(model, data=Demo.growth)
summary(fit)
fitmeasures(fit)
fit3 <- multi_optim(fit,lambda=0.2,type="ridge",gradFun="none")
summary(fit3)
}
}
\keyword{multiple}
\keyword{optim}

