% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalised.R
\name{glmsel}
\alias{glmsel}
\title{Generalised linear models with variable selection}
\usage{
glmsel(formula, data=environment(), varsel=FALSE, criterion="AIC",
direction="backward", indices=NULL, train=0.3, family, enet.alpha=0.5)
}
\arguments{
\item{formula}{an object of class "formula"; a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment containg the variables in the model. If not specified, the variables are taken from the current environment.}

\item{varsel}{a method of variable selection to be used. The default is \code{"FALSE"}. Available methods include: stepwise regression \code{"step"}, LASSO \code{"lasso"}, elastic net\code{"enet"}.}

\item{criterion}{when \code{varsel="step", criterion} allows to select a method of calculating statistic for model comparison. The default is  \code{"AIC"}. Less liberal, BIC penalty can be used by typing \code{"BIC"}.}

\item{direction}{the mode of stepwise search, can be one of \code{"both"}, \code{"backward"}, or \code{"forward"}, with a default of \code{"both"}. If the scope argument is missing the default for \code{direction} is \code{"backward"}.}

\item{indices}{vector of \code{0} and \code{1} values indicating which observations are to be used as train and test when \code{varsel="lasso" or "enet"}.}

\item{train}{if \code{indices=NULL}, the function will randomly assign observations as train and test. \code{train} specifies what percentage of data will be used as train observations. Can take values from \code{0.1} to \code{0.9}.}

\item{family}{a description of the error distribution and link function to be used in the model. This can be a character string naming a family function.}

\item{enet.alpha}{The elastic net mixing parameter, with 0=a= 1. The penalty is defined as\deqn{(1-a)/2||\beta||\_{2}^2+a||\beta||_1}\code{alpha=1} is the lasso penalty, and \code{alpha=0} the ridge penalty. The default value is \code{0.5}.}
}
\value{
A "glmsel" object is returned, for which print, plot and summary methods can be used.
}
\description{
\code{glmsel} is used to fit generalised linear models with optionally performing variable selection using stepwise regression, lasso or elastic net methods.
}
\examples{
data(bank)
glmsel(y~age+as.factor(job)+as.factor(marital)+as.factor(education)+as.factor(default)+balance
+as.factor(housing)+as.factor(loan)+as.factor(contact)+as.factor(day)+month+duration+campaign
+pdays+previous, data=bank, varsel="enet")
}
\author{
Michal Knut \email{1105406k@student.gla.ac.uk}.
}

