% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REGModel.R
\name{REGModel}
\alias{REGModel}
\title{R6 class representing a regression model}
\description{
Contains fields storing data and methods to build, process and visualize
a regression model.
Currently, this class is designed for CoxPH and GLM regression models.
}
\examples{
library(survival)
test1 <- data.frame(
  time = c(4, 3, 1, 1, 2, 2, 3),
  status = c(1, 1, 1, 0, 1, 1, 0),
  x = c(0, 2, 1, 1, 1, 0, 0),
  sex = c(0, 0, 0, 0, 1, 1, 1)
)
test1$sex <- factor(test1$sex)

# --------------
# Build a model
# --------------

# way 1:
mm <- REGModel$new(
  test1,
  Surv(time, status) ~ x + strata(sex)
)
mm
as.data.frame(mm$result)
if (require("see")) mm$plot()
mm$print() # Same as print(mm)

# way 2:
mm2 <- REGModel$new(
  test1,
  recipe = list(
    x = c("x", "strata(sex)"),
    y = c("time", "status")
  )
)
mm2

# Add other parameters, e.g., weights
# For more, see ?coxph
mm3 <- REGModel$new(
  test1,
  recipe = list(
    x = c("x", "strata(sex)"),
    y = c("time", "status")
  ),
  weights = c(1, 1, 1, 2, 2, 2, 3)
)
mm3$args

# ----------------------
# Another type of model
# ----------------------
library(stats)
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
outcome <- gl(3, 1, 9)
treatment <- gl(3, 3)
data <- data.frame(treatment, outcome, counts)

mm4 <- REGModel$new(
  data,
  counts ~ outcome + treatment,
  f = "poisson"
)
mm4
mm4$plot_forest()
mm4$get_forest_data()
mm4$plot_forest()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{a \code{data.table} storing modeling data.}

\item{\code{recipe}}{an R \code{formula} storing model formula.}

\item{\code{terms}}{all terms (covariables, i.e. columns) used for building model.}

\item{\code{args}}{other arguments used for building model.}

\item{\code{model}}{a constructed model.}

\item{\code{type}}{model type (class).}

\item{\code{result}}{model result, a object of \code{parameters_model}. Can be converted into
data.frame with \code{\link[=as.data.frame]{as.data.frame()}} or \code{\link[data.table:as.data.table]{data.table::as.data.table()}}.}

\item{\code{forest_data}}{more detailed data used for plotting forest.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{REGModel$new()}}
\item \href{#method-get_forest_data}{\code{REGModel$get_forest_data()}}
\item \href{#method-plot_forest}{\code{REGModel$plot_forest()}}
\item \href{#method-plot}{\code{REGModel$plot()}}
\item \href{#method-print}{\code{REGModel$print()}}
\item \href{#method-clone}{\code{REGModel$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Build a \code{REGModel} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModel$new(
  data,
  recipe,
  ...,
  f = c("coxph", "binomial", "gaussian", "Gamma", "inverse.gaussian", "poisson",
    "quasi", "quasibinomial", "quasipoisson"),
  exp = NULL,
  ci = 0.95
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a \code{data.table} storing modeling data.}

\item{\code{recipe}}{an R \code{formula} or a list with two elements 'x' and 'y',
where 'x' is for covariables and 'y' is for label. See example for detail
operation.}

\item{\code{...}}{other parameters passing to corresponding regression model function.}

\item{\code{f}}{a length-1 string specifying modeling function or family of \code{\link[=glm]{glm()}}, default is 'coxph'.
Other options are members of GLM family, see \code{\link[stats:family]{stats::family()}}.
'binomial' is logistic, and 'gaussian' is linear.}

\item{\code{exp}}{logical, indicating whether or not to exponentiate the the coefficients.}

\item{\code{ci}}{confidence Interval (CI) level. Default to 0.95 (95\%).
e.g. \code{\link[survival:coxph]{survival::coxph()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{REGModel} R6 object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_forest_data"></a>}}
\if{latex}{\out{\hypertarget{method-get_forest_data}{}}}
\subsection{Method \code{get_forest_data()}}{
get tidy data for plotting forest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModel$get_forest_data(separate_factor = FALSE, global_p = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{separate_factor}}{separate factor/class as a blank row.}

\item{\code{global_p}}{if \code{TRUE}, return global p value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_forest"></a>}}
\if{latex}{\out{\hypertarget{method-plot_forest}{}}}
\subsection{Method \code{plot_forest()}}{
plot forest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModel$plot_forest(ref_line = NULL, xlim = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ref_line}}{reference line, default is \code{1} for HR.}

\item{\code{xlim}}{limits of x axis.}

\item{\code{...}}{other plot options passing to \code{\link[forestploter:forest]{forestploter::forest()}}.
Also check \url{https://github.com/adayim/forestploter} to see more complex adjustment of the result plot.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
print the \code{REGModel$result} with default plot methods from \strong{see} package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModel$plot(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{other parameters passing to \code{plot()} in \code{see:::plot.see_parameters_model} function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print the \code{REGModel} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModel$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{unused.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{REGModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
