% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McpLogistic.R
\name{McpLogistic}
\alias{McpLogistic}
\title{MCP logistic regression for a given lambda.}
\usage{
McpLogistic(X, Y, lambda, r = 5, alpha.i = 1, folds = 5)
}
\arguments{
\item{X}{a matrix of predictors.}

\item{Y}{a vector of the binary response.}

\item{lambda}{the tuning parameter that imposes sparsity.}

\item{r}{the regularization parameter in MCP.}

\item{alpha.i}{by default, the program use the lasso penalty for choosing initial values of
the coefficient vector. alpha.i is the Elastic-Net mixing parameter, with \eqn{0 \le alpha.i \le 1}. alpha.i=1 is the
lasso penalty, and alpha.i=0 is the ridge penalty. If alpha.i is assigned to be -1, the program will use zeroes
as initial coefficients.}

\item{folds}{the number of folds for cross-validation.}
}
\value{
the estimated coefficients vector.
}
\description{
This function makes predictions for MCP logistic regression for a given value of lambda.
Typical usage is to have the CV.McpLogistic function compute the optimal lambda, then provide it to
the McpLogistic function.
}
\examples{
b = McpLogistic(regnet$X, regnet$Y, 0.075)
inds = which(regnet$beta != 0)
sel = which(b != 0)
tp = length(intersect(inds, sel))
fp = length(sel) - tp
list(tp=tp, fp=fp)
}
\references{
zhang, CH. (2010). Nearly unbiased variable selection under minimax concave penalty.
Annals of Statistics, 38(2):894-942.
}
\seealso{
\code{\link{CV.McpLogistic}}
}
