% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_regmedint_class_user_methods.R
\name{confint.regmedint}
\alias{confint.regmedint}
\title{Confidence intervals for mediation prameter estimates.}
\usage{
\method{confint}{regmedint}(
  object,
  parm = NULL,
  level = 0.95,
  a0 = NULL,
  a1 = NULL,
  m_cde = NULL,
  c_cond = NULL,
  ...
)
}
\arguments{
\item{object}{An object of the \code{\link{regmedint}} class.}

\item{parm}{For compatibility with generic. Ignored.}

\item{level}{A numeric vector of length one. Requested confidence level. Defaults to 0.95.}

\item{a0}{A numeric vector of length one.}

\item{a1}{A numeric vector of length one.}

\item{m_cde}{A numeric vector of length one. A mediator value at which the controlled direct effect (CDE) conditional on the adjustment covariates is evaluated. If not provided, the default value supplied to the call to \code{\link{regmedint}} will be used. Only the CDE is affected.}

\item{c_cond}{A numeric vector as long as the number of adjustment covariates. A set of covariate values at which the conditional natural effects are evaluated.}

\item{...}{For compatibility with generic.}
}
\value{
A numeric matrix of the lower limit and upper limit.
}
\description{
Construct Wald approximate confidence intervals for the quantities of interest.
}
\examples{
library(regmedint)
data(vv2015)
regmedint_obj <- regmedint(data = vv2015,
                           ## Variables
                           yvar = "y",
                           avar = "x",
                           mvar = "m",
                           cvar = c("c"),
                           eventvar = "event",
                           ## Values at which effects are evaluated
                           a0 = 0,
                           a1 = 1,
                           m_cde = 1,
                           c_cond = 0.5,
                           ## Model types
                           mreg = "logistic",
                           yreg = "survAFT_weibull",
                           ## Additional specification
                           interaction = TRUE,
                           casecontrol = FALSE)
confint(regmedint_obj)
## Evaluate at different values
confint(regmedint_obj, m_cde = 0, c_cond = 1)
## Change confidence level
confint(regmedint_obj, m_cde = 0, c_cond = 1, level = 0.99)

}
