% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfdata.R
\name{print.rfdata}
\alias{print.rfdata}
\title{Print function for class rfdata}
\usage{
\method{print}{rfdata}(x, ...)
}
\arguments{
\item{x}{an object of class \code{rfdata}.}

\item{...}{other options to pass to the function.}
}
\value{
This function does not return any value.
}
\description{
This methods displays the basic information about the noise
filtering process contained in an object of class \code{rfdata}.
}
\details{
This function presents the basic information of the regression noise filter and the resulting
noisy dataset contained in the object \code{x} of class \code{rfdata}.
The information offered is as follows:
\itemize{
   \item the name of the noise filtering model.
   \item the parameters associated with the noise filtering model.
   \item the number of noisy and clean samples in the dataset.
}
}
\examples{
# load the dataset
data(rock)

# apply the regression noise filter
set.seed(9)
output <- regAENN(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# print the results
print(output)

}
\seealso{
\code{\link{summary.rfdata}}, \code{\link{regAENN}}, \code{\link{regENN}}, \code{\link{regGE}}, \code{\link{regEF}}
}
