% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLS_CS.R
\name{gls_cs}
\alias{gls_cs}
\title{Cross-sectional FoSR using GLS}
\usage{
gls_cs(
  formula,
  data = NULL,
  Kt = 5,
  basis = "bs",
  sigma = NULL,
  verbose = TRUE,
  CI.type = "pointwise"
)
}
\arguments{
\item{formula}{a formula indicating the structure of the proposed model.}

\item{data}{an optional data frame, list or environment containing the 
variables in the model. If not found in data, the variables are taken from 
environment(formula), typically the environment from which the function is 
called.}

\item{Kt}{number of spline basis functions used to estimate coefficient functions}

\item{basis}{basis type; options are "bs" for b-splines and "pbs" for periodic
b-splines}

\item{sigma}{optional covariance matrix used in GLS; if \code{NULL}, OLS will be
used to estimated fixed effects, and the covariance matrix will be estimated from
the residuals.}

\item{verbose}{logical defaulting to \code{TRUE} -- should updates on progress be printed?}

\item{CI.type}{Indicates CI type for coefficient functions; options are "pointwise" and
"simultaneous"}
}
\description{
Fitting function for function-on-scalar regression for cross-sectional data.
This function estimates model parameters using GLS: first, an OLS estimate of 
spline coefficients is estimated; second, the residual covariance is estimated
using an FPC decomposition of the OLS residual curves; finally, a GLS estimate
of spline coefficients is estimated. Although this is in the `BayesFoSR` package,
there is nothing Bayesian about this FoSR.
}
\references{
Goldsmith, J., Kitago, T. (2016).
Assessing Systematic Effects of Stroke on Motor Control using Hierarchical 
Function-on-Scalar Regression. \emph{Journal of the Royal Statistical Society:
Series C}, 65 215-236.
}
\author{
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
