% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_feats.R
\name{extract_from_xm}
\alias{extract_from_xm}
\title{Extract some features from an XM accession}
\usage{
extract_from_xm(listName, feat = "tissue")
}
\arguments{
\item{listName}{a downloaded flat file from the nuccore NCBI database}

\item{feat}{a feature to be extracted. Allowed features include "sex", "tissue" or "genotype"}
}
\description{
Parses an XM acession (Genbank format) and extract some features provided by
the user.
}
\examples{
xm <- "XM_020388824"
# First, get the character vector containing the fetched record
mrna_gb <- rentrez::entrez_fetch(db = "nuccore", id = xm, rettype = "gp")
extract_from_xm(mrna_gb, feat = "sex")
extract_from_xm(mrna_gb, feat = "genotype")
extract_from_xm(mrna_gb, feat = "tissue")
}
\author{
Jose V. Die
}
