% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statement.R
\docType{class}
\encoding{UTF-8}
\name{Statement-class}
\alias{Statement-class}
\alias{Statement}
\title{An RDF Statement object}
\description{
A Statement object is created using the provided subject, predicate and object.
}
\details{
A Statement object can be created from Node objects that are provided for the subject,
predicate and object. An alternative way to create a Statement object is to provide the
subject, predicate and object as character values. If this later method is used, the character values will be evaluated to
determine the appropriate RDF type for the subject and object. Note that the RDF type for the predicate will always
be 'uri' (aka 'resource'). If the automatic determination of RDF types is not desired, then the \code{subjectType} and
\code{objectType} parameters can be specified to explicitly set the RDF types.
}
\section{Slots}{

\describe{
\item{\code{librdf_statement}}{A redland statement object}
}}

\section{Methods}{

\itemize{
\item{\code{\link{Statement-initialize}}}{: Initialize a Statement object.}
\item{\code{\link{getTermType}}}{: Return the redland node type for the specified RDF term in a statement.}
\item{\code{\link{freeStatement}}}{: Free memory used by a librdf statement.}
}
}

\examples{
world <- new("World")
# Create nodes manually and add to the statment
subject <- new("Node", blank="_:myid1", world)
predicate <- new("Node", uri="http://www.example.com/isa", world)
object <- new("Node", literal="thing", world)
stmt <- new("Statement", world, subject, predicate, object)

# Create the statement specifying node values directly
stmt <- new("Statement", world, subject="http://www.example.com/myevent",
                                predicate="http://example.com/occurredAt",
                                object="Tue Feb 17 14:05:13 PST 2015")
stmt <- new("Statement", world, subject=NULL, 
                                predicate="http://www.example.com/hasAddr",
                                object="http://www.nothing.com", objectType="literal")
stmt <- new("Statement", world, subject="http://www.example.com/BobSmith", 
                                predicate="http://www.example.com/says",
                                object="¡Hola, amigo! ¿Cómo estás?", 
                                objectType="literal",
                                language="es")
}
\seealso{
\code{\link{redland}}{: redland package}
}
\keyword{classes}
