% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj.R
\name{redist.plot.contr_pfdr}
\alias{redist.plot.contr_pfdr}
\title{Plot a Projective Contrast with positive False Discovery Rate (pFDR) Control}
\usage{
redist.plot.contr_pfdr(
  map,
  contr,
  level = 0.05,
  density = 0.2,
  spacing = 0.015
)
}
\arguments{
\item{map}{A \link{redist_map} object}

\item{contr}{The output of \code{\link[=proj_contr]{proj_contr()}} with \code{pfdr=TRUE}: A vector containing
the contrast and an attribute \code{"q"} containing the q-values.}

\item{level}{The positive false discovery rate level to control.}

\item{density}{The density of the hatching (roughly what portion is shaded).}

\item{spacing}{The spacing of the hatches.}
}
\value{
A ggplot.
}
\description{
Plot a projective contrast on a map with areas selected by the pFDR control
procedure hatched.
}
\examples{
# example code
set.seed(1812)
data(iowa)
map <- redist_map(iowa, existing_plan = cd_2010, pop_tol = 0.01)
plans <- redist_smc(map, 50, silent = TRUE)
plans$dem <- group_frac(map, dem_08, tot_08, plans)

pc = proj_contr(plans, dem, pfdr=TRUE)
redist.plot.contr_pfdr(map, pc, level=0.4) # high `level` just to demonstrate


}
\concept{plot}
