% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFieldNames.R
\name{exportFieldNames}
\alias{exportFieldNames}
\alias{exportFieldNames.redcapDbConnection}
\alias{exportFieldNames.redcapApiConnection}
\title{Export the Export Field Names for a Project}
\usage{
exportFieldNames(
  rcon,
  ...,
  error_handling = getOption("redcap_error_handling")
)

\method{exportFieldNames}{redcapDbConnection}(
  rcon,
  fields = NULL,
  bundle = NULL,
  ...,
  error_handling = getOption("redcap_error_handling")
)

\method{exportFieldNames}{redcapApiConnection}(
  rcon,
  fields = NULL,
  bundle = NULL,
  ...,
  error_handling = getOption("redcap_error_handling")
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}.}

\item{...}{Arguments to be passed to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{fields}{Field name to be returned.  If \code{NULL}, all fields are returned.}

\item{bundle}{A \code{redcapProject} object as created by \code{redcapProjectInfo}.}
}
\value{
A data frame containing three fields: 
\itemize{
  \item{\code{original_field_name} }{The field name as recorded in the 
       data dictionary}
  \item{\code{choice_value} }{represents the raw coded value for a checkbox 
       choice. For non-checkbox fields, this will always be \code{NA}.}
  \item{\code{export_field_name} }{The field name specific to the field.
       For non-checkbox fields, this is the same as \code{original_field_name}.
       For checkbox fields, it is the field name appended with 
       \code{___[choice_value]}.}
}
}
\description{
Retrieve a data frame giving the original (as defined in REDCap)
  field name, choice values (for checkboxes), and the export field name.
}
\section{REDCap API Documentation}{

This function returns a list of the export/import-specific version of field names for 
all fields (or for one field, if desired) in a project. This is mostly used for 
checkbox fields because during data exports and data imports, 
checkbox fields have a different variable name used than the exact one 
defined for them in the Online Designer and Data Dictionary, in which 
*each checkbox option* gets represented as its own export field name in the 
following format: field_name + triple underscore + converted coded value for the 
choice. For non-checkbox fields, the export field name will be exactly the same 
as the original field name. Note: The following field types will be automatically 
removed from the list returned by this method since they cannot be utilized during 
the data import process: "calc", "file", and "descriptive".

The list that is returned will contain the three following attributes for each 
field/choice: "original_field_name", "choice_value", and "export_field_name". 
The choice_value attribute represents the raw coded value for a checkbox choice. 
For non-checkbox fields, the choice_value attribute will always be blank/empty. 
The export_field_name attribute represents the export/import-specific version of 
that field name.
}

\section{REDCap Version}{

6.5.0+ (perhaps earlier; need to confirm its introduction)
}

\section{Known REDCap Limitations}{
 
In 6.5.0, it has been observed that "slider" fields are not returned.  

Signature fields are also not included, but these are effectively the same as 
"file" fields.  This isn't a true limitation, but is documented here just to
avoid confusion.
}

\references{
Please refer to your institution's API documentation
(https://YOUR_REDCAP_URL/redcap/api/help)

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Stephen Lane
}
