% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{countr}
\alias{countr}
\title{Countries of occurrence.}
\usage{
countr(spData, ISO = FALSE)
}
\arguments{
\item{spData}{Either a matrix of longitude and latitude (two columns) of each occurrence record or a presence/absence map as a RasterLayer object.}

\item{ISO}{Outputs either country names (FALSE) or ISO codes (TRUE).}
}
\value{
A vector with country names or codes.
}
\description{
Extracts the names or ISO codes of countries of occurrence of a species based on either records or predicted distribution.
}
\details{
Country boundaries and designations are based on data(data.worldborders) from package maptools.
}
\examples{
data(data.records)
data(data.sp)
countr(data.records)
countr(data.sp, ISO = TRUE)
}

