% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_threshold.R
\name{select_threshold}
\alias{select_threshold}
\title{Select pairs for linkage using a threshold}
\usage{
select_threshold(pairs, threshold, weight, var = "select")
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{threshold}{the threshold to apply. Pairs with a score above the 
threshold are selected.}

\item{weight}{name of the score/weight variable of the pairs. When not given
and \code{attr(pairs, "score")} is defined, that is used.}

\item{var}{the name of the new variable to create in pairs. This will be a
logical variable with a value of \code{TRUE} for the selected pairs.}
}
\value{
Returns the \code{pairs} with the variable given by \code{var} added. This
is a logical variable indicating which pairs are selected a matches.
}
\description{
Select pairs for linkage using a threshold
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")
pairs <- compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))
pairs <- score_simsum(pairs)
# Select pairs with a simsum > 5 as matches
pairs <- select_threshold(pairs, 5)

}
