% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num2factor.R
\name{step_num2factor}
\alias{step_num2factor}
\alias{tidy.step_num2factor}
\title{Convert Numbers to Factors}
\usage{
step_num2factor(
  recipe,
  ...,
  role = NA,
  transform = function(x) x,
  trained = FALSE,
  levels,
  ordered = FALSE,
  skip = FALSE,
  id = rand_id("num2factor")
)

\method{tidy}{step_num2factor}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which variables will
converted to factors. See \code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are created.}

\item{transform}{A function taking a single argument \code{x} that can be used
to modify the numeric values prior to determining the levels (perhaps using
\code{\link[base:integer]{base::as.integer()}}). The output of a function should be an integer that
corresponds to the value of \code{levels} that should be assigned. If not an
integer, the value will be converted to an integer during \code{bake()}.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{levels}{A character vector of values that will be used as the levels.
These are the numeric data converted to character and ordered. This is
modified once \code{\link[=prep.recipe]{prep.recipe()}} is executed.}

\item{ordered}{A single logical value; should the factor(s) be ordered?}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_num2factor} object.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any). For the \code{tidy} method, a tibble with
columns \code{terms} (the selectors or variables selected) and \code{ordered}.
}
\description{
\code{step_num2factor} will convert one or more numeric vectors to factors
(ordered or unordered). This can be useful when categories are encoded as
integers.
}
\examples{
library(dplyr)
library(modeldata)
data(attrition)

attrition \%>\%
  group_by(StockOptionLevel) \%>\%
  count()

amnt <- c("nothin", "meh", "some", "copious")

rec <-
  recipe(Attrition ~ StockOptionLevel, data = attrition) \%>\%
  step_num2factor(
    StockOptionLevel,
    transform = function(x) x + 1,
    levels = amnt
  )

encoded <- rec \%>\% prep() \%>\% juice()

table(encoded$StockOptionLevel, attrition$StockOptionLevel)


# an example for binning

binner <- function(x) {
  x <- cut(x, breaks = 1000 * c(0, 5, 10, 20), include.lowest = TRUE)
  # now return the group number
  as.numeric(x)
}

inc <- c("low", "med", "high")

rec <-
  recipe(Attrition ~ MonthlyIncome, data = attrition) \%>\%
  step_num2factor(
    MonthlyIncome,
    transform = binner,
    levels = inc,
    ordered = TRUE
  ) \%>\%
  prep()

encoded <- juice(rec)

table(encoded$MonthlyIncome, binner(attrition$MonthlyIncome))

# What happens when a value is out of range?
ceo <- attrition \%>\% slice(1) \%>\% mutate(MonthlyIncome = 10^10)

bake(rec, ceo)
}
\seealso{
\code{\link[=step_factor2string]{step_factor2string()}}, \code{\link[=step_string2factor]{step_string2factor()}}, \code{\link[=step_dummy]{step_dummy()}}
}
\concept{factors}
\concept{preprocessing}
\concept{variable_encodings}
\keyword{datagen}
