% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{posdeclist}
\alias{posdeclist}
\title{Multiple point position decision in relation to a set of stacked surfaces (3D)
for multiple data.frames in a list}
\usage{
posdeclist(crdflist, maplist)
}
\arguments{
\item{crdflist}{list of data.frames with the spatial coordinates of the points of
interest (for details see \code{\link{posdec}})}

\item{maplist}{list of data.frames which contain the points that make up the surfaces}
}
\value{
list of data.frames with the spatial coordinates of the points of interest
and the respective position information
}
\description{
\code{posdeclist} works as \code{\link{posdec}} but not just for a single data.frame
with individual points but for a list of data.frames
}
\examples{
df1 <- data.frame(
  x = rnorm(50),
  y = rnorm(50),
  z = rnorm(50) - 5
)

df2 <- data.frame(
  x = rnorm(50),
  y = rnorm(50),
  z = rnorm(50) + 5
)

lpoints <- list(df1, df2)

maps <- kriglist(lpoints, lags = 3, model = "spherical")

hexadf1 <- data.frame(
  x = c(0, 1, 0, 4, 5, 5, 5, 5),
  y = c(1, 1, 4, 4, 1, 1, 4, 4),
  z = c(1, 5, 1, 6, 1, 5, 1, 3)
)

hexadf2 <- data.frame(
  x = c(0, 1, 0, 4, 5, 5, 5, 5),
  y = c(1, 1, 4, 4, 1, 1, 4, 4),
  z = c(-1, -5, -1, -6, -1, -5, -1, -3)
)

cx1 <- fillhexa(hexadf1, 0.1)
cx2 <- fillhexa(hexadf2, 0.1)

cubelist <- list(cx1, cx2)

posdeclist(cubelist, maps)

}
\seealso{
Other posdecfuncs: \code{\link{posdec}}
}

