library(rearrr)
context("rotate_3d()")


test_that("fuzz testing rotate_3d()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(15),
    "y" = runif(15),
    "z" = runif(15),
    "g" = rep(c(1, 2, 3, 4, 5), each = 3),
    stringsAsFactors = FALSE
  ) %>%
    dplyr::as_tibble()

  # Check that df hasn't changed
  ## Testing 'df'                                                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(df),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    df[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    df[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    df[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    df[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(df),
    c("x", "y", "z", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(df),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(df),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(df),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(df)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df'                                                  ####

  # Fuzzing     ####

  # Generate expectations for 'rotate_3d'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = rotate_3d,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1, 2, 3, 4, 5), "hej", NA),
  #     "x_col" = list("x", "y", NA),
  #     "y_col" = list("y", "x", NA),
  #     "z_col" = list("z", "x", "uhh", NA),
  #     "x_deg" = list(0, 10, -10, 400, -400, c(45, -45), "hej", NA),
  #     "y_deg" = list(0, 10, -10, 400, -400, c(45, -45), "hej", NA),
  #     "z_deg" = list(0, 10, -10, 400, -400, c(45, -45), "hej", NA),
  #     "suffix" = list("", "_rotated", NA),
  #     "origin" = list(c(0, 0, 0), c(0.3, -0.3, 0.5), 0, "h", c(NA, 1, 0.4), c(NA, NA, NA),  NA),
  #     "origin_fn" = list(NULL, centroid),
  #     "keep_original" = list(FALSE),
  #     "degrees_col_name" = list(".degrees", ".nooot", NA),
  #     "origin_col_name" = list(".origin", ".centroid", NA),
  #     "overwrite" = list(TRUE, FALSE)
  #   ),
  #   extra_combinations = list(
  #       list("data" = c(1, 2, 3, 4, 5), "x_col" = NULL, "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #       list("data" = c(1, 2, 3, 4, 5), "x_col" = "x", "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #       list("data" = dplyr::group_by(df, g), "x_deg" = 10, "origin_fn" = centroid),
  #       list("keep_original" = TRUE, "suffix" = "_rotated"),
  #       list("overwrite" = FALSE, "degrees_col_name" = "g")
  #   ),
  #   indentation = 2
  # )



  ## Testing 'rotate_3d'                                                      ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".degrees_str"]],
    c("x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = dplyr::group_by(df, g), x_c...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- rotate_3d(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".degrees_str"]],
    c("x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("g", "x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = c(1, 2, 3, 4, 5), x_col = "...
  # Changed from baseline: data = c(1, 2, 3, 4, 5)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(rotate_3d(data = c(1, 2, 3, 4, 5), x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = "hej", x_col = "x", y_col =...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(rotate_3d(data = "hej", x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = NA, x_col = "x", y_col = "y...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(rotate_3d(data = NA, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = NULL, x_col = "x", y_col = ...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(rotate_3d(data = NULL, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = dplyr::group_by(df, g), x_c...
  # Changed from baseline: data, x_deg, origin_fn
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(rotate_3d(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", z_col = "z", x_deg = 10, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_17365 <- xpectr::suppress_mw(rotate_3d(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", z_col = "z", x_deg = 10, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["y"]],
    c(0.92007, 0.94494, 0.17072, 0.44672, 0.64905, 0.84358, 0.21075,
      1.01323, 0.85028, 0.06255, 0.52809, 0.39621, 0.98007, 0.36572,
      0.84292),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["z"]],
    c(0.7816, 0.86058, 0.29459, 0.6527, -0.00336, 0.8727, -0.08308,
      0.26184, 0.94283, 0.5669, 0.41319, 0.44701, 0.07476, 0.91698,
      0.45098),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".degrees_str"]],
    c("x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0",
      "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0",
      "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0",
      "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("g", "x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(15L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = c(1, 2, 3, 4, 5), x_col = N...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(rotate_3d(data = c(1, 2, 3, 4, 5), x_col = NULL, y_col = NULL, z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("3 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'.\n * Variable 'x_col': Must be of type 'string', not 'NULL'.\n * Variable 'y_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = c(1, 2, 3, 4, 5), x_col = "...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(rotate_3d(data = c(1, 2, 3, 4, 5), x_col = "x", y_col = NULL, z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("2 assertions failed:\n * Variable 'data': Must be of type 'data.frame', not 'double'.\n * Variable 'y_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "y", y_col = "y...
  # Changed from baseline: x_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "y", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'c(x_col, y_col, z_col)': Contains duplicated values, position 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = NA, y_col = "y"...
  # Changed from baseline: x_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = NA, y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = NULL, y_col = "...
  # Changed from baseline: x_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = NULL, y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "x...
  # Changed from baseline: y_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "x", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'c(x_col, y_col, z_col)': Contains duplicated values, position 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = NA...
  # Changed from baseline: y_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = NA, z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = NU...
  # Changed from baseline: y_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = NULL, z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_col = "uhh"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "uhh", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * These names in the 'col(s)' argument were not found in 'data': uhh."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c(purrr_error, "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = NA, x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "x", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'c(x_col, y_col, z_col)': Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = NULL, x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_col': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: x_deg = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_15603 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 10, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_15603),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15603[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_15603[["y"]],
    c(0.79765, 0.82253, 0.04831, 0.3488, 0.55113, 0.74566, 0.13533,
      0.93781, 0.77486, -0.02505, 0.44049, 0.3086, 0.88548, 0.27113,
      0.74833),
    tolerance = 1e-4)
  expect_equal(
    output_15603[["z"]],
    c(0.88962, 0.9686, 0.40261, 0.75724, 0.10119, 0.97725, 0.03131,
      0.37622, 1.05722, 0.6168, 0.46308, 0.49691, 0.19414, 1.03637,
      0.57036),
    tolerance = 1e-4)
  expect_equal(
    output_15603[[".degrees_str"]],
    c("x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0",
      "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0",
      "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0",
      "x=10,y=0,z=0", "x=10,y=0,z=0", "x=10,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_15603),
    c("x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15603),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15603),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15603),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15603)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: x_deg = -10
  xpectr::set_test_seed(42)
  # Assigning output
  output_19040 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = -10, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19040),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19040[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["y"]],
    c(1.05382, 1.1042, 0.1831, 0.58676, 0.55251, 1.03493, 0.13788, 1.00993,
      1.08972, 0.18742, 0.57231, 0.45995, 0.89848, 0.60923, 0.89828),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["z"]],
    c(0.56316, 0.62887, 0.36181, 0.59228, -0.09341, 0.66328, -0.01686,
      0.03278, 0.72844, 0.58817, 0.2845, 0.36139, -0.12042, 0.88113,
      0.28002),
    tolerance = 1e-4)
  expect_equal(
    output_19040[[".degrees_str"]],
    c("x=-10,y=0,z=0", "x=-10,y=0,z=0", "x=-10,y=0,z=0", "x=-10,y=0,z=0",
      "x=-10,y=0,z=0", "x=-10,y=0,z=0", "x=-10,y=0,z=0", "x=-10,y=0,z=0",
      "x=-10,y=0,z=0", "x=-10,y=0,z=0", "x=-10,y=0,z=0", "x=-10,y=0,z=0",
      "x=-10,y=0,z=0", "x=-10,y=0,z=0", "x=-10,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19040),
    c("x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19040),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19040),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19040),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19040)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: x_deg = 400
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 400, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_deg': Element 1 is not <= 360."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: x_deg = -400
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = -400, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_deg': Element 1 is not >= -360."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: x_deg = c(45, -45)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = c(45, -45), y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_deg', 'y_deg', and 'z_deg' must all have the same length but had lengths: 2, 1, 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: x_deg = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = "hej", y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_deg': Must be of type 'numeric', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: x_deg = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = NA, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_deg': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: x_deg = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13902 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = NULL, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_deg': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: y_deg = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_19057 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 10, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19057),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19057[["x"]],
    c(1.02899, 1.06368, 0.34919, 0.93681, 0.63268, 0.65584, 0.72667,
      0.16868, 0.80444, 0.80059, 0.5167, 0.78386, 0.92697, 0.4206,
      0.53024),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["z"]],
    c(0.56754, 0.63601, 0.33252, 0.53055, -0.10755, 0.73012, -0.12068,
      0.18112, 0.77874, 0.48005, 0.29431, 0.30428, -0.12544, 0.91439,
      0.34492),
    tolerance = 1e-4)
  expect_equal(
    output_19057[[".degrees_str"]],
    c("x=0,y=10,z=0", "x=0,y=10,z=0", "x=0,y=10,z=0", "x=0,y=10,z=0",
      "x=0,y=10,z=0", "x=0,y=10,z=0", "x=0,y=10,z=0", "x=0,y=10,z=0",
      "x=0,y=10,z=0", "x=0,y=10,z=0", "x=0,y=10,z=0", "x=0,y=10,z=0",
      "x=0,y=10,z=0", "x=0,y=10,z=0", "x=0,y=10,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19057),
    c("x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19057),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19057),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19057),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19057)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: y_deg = -10
  xpectr::set_test_seed(42)
  # Assigning output
  output_14469 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = -10, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14469),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14469[["x"]],
    c(0.77283, 0.782, 0.2144, 0.69885, 0.63131, 0.36658, 0.72412, 0.09656,
      0.48958, 0.58812, 0.38488, 0.63252, 0.91397, 0.08249, 0.3803),
    tolerance = 1e-4)
  expect_equal(
    output_14469[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_14469[["z"]],
    c(0.88524, 0.96145, 0.4319, 0.81897, 0.11533, 0.9104, 0.13513, 0.22789,
      1.00691, 0.72492, 0.45328, 0.55402, 0.19917, 1.0031, 0.50547),
    tolerance = 1e-4)
  expect_equal(
    output_14469[[".degrees_str"]],
    c("x=0,y=-10,z=0", "x=0,y=-10,z=0", "x=0,y=-10,z=0", "x=0,y=-10,z=0",
      "x=0,y=-10,z=0", "x=0,y=-10,z=0", "x=0,y=-10,z=0", "x=0,y=-10,z=0",
      "x=0,y=-10,z=0", "x=0,y=-10,z=0", "x=0,y=-10,z=0", "x=0,y=-10,z=0",
      "x=0,y=-10,z=0", "x=0,y=-10,z=0", "x=0,y=-10,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14469),
    c("x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14469),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14469),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14469),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14469)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: y_deg = 400
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 400, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_deg': Element 1 is not <= 360."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: y_deg = -400
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = -400, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_deg': Element 1 is not >= -360."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: y_deg = c(45, -45)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = c(45, -45), z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_deg', 'y_deg', and 'z_deg' must all have the same length but had lengths: 1, 2, 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: y_deg = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13881 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = "hej", z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_deg': Must be of type 'numeric', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: y_deg = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = NA, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_deg': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: y_deg = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10039 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = NULL, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_deg': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_deg = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_18329 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 10, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18329),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18329[["x"]],
    c(0.73768, 0.75297, 0.26139, 0.73535, 0.5347, 0.35423, 0.70131,
      -0.0391, 0.48262, 0.68004, 0.3615, 0.64043, 0.76319, 0.17393,
      0.3101),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["y"]],
    c(1.08459, 1.12609, 0.16539, 0.61199, 0.66326, 0.98044, 0.26451,
      0.99725, 1.04637, 0.20362, 0.58589, 0.50915, 1.05428, 0.48453,
      0.90358),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_18329[[".degrees_str"]],
    c("x=0,y=0,z=10", "x=0,y=0,z=10", "x=0,y=0,z=10", "x=0,y=0,z=10",
      "x=0,y=0,z=10", "x=0,y=0,z=10", "x=0,y=0,z=10", "x=0,y=0,z=10",
      "x=0,y=0,z=10", "x=0,y=0,z=10", "x=0,y=0,z=10", "x=0,y=0,z=10",
      "x=0,y=0,z=10", "x=0,y=0,z=10", "x=0,y=0,z=10"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_18329),
    c("x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18329),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18329),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18329),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18329)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_deg = -10
  xpectr::set_test_seed(42)
  # Assigning output
  output_10073 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = -10, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10073),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10073[["x"]],
    c(1.06414, 1.09271, 0.30219, 0.90031, 0.7293, 0.66819, 0.74948,
      0.30434, 0.8114, 0.70867, 0.54008, 0.77595, 1.07775, 0.32916,
      0.60044),
    tolerance = 1e-4)
  expect_equal(
    output_10073[["y"]],
    c(0.76688, 0.80064, 0.06601, 0.32358, 0.44038, 0.80016, 0.0087,
      0.95048, 0.8182, -0.04125, 0.42691, 0.2594, 0.72967, 0.39582,
      0.74303),
    tolerance = 1e-4)
  expect_equal(
    output_10073[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_10073[[".degrees_str"]],
    c("x=0,y=0,z=-10", "x=0,y=0,z=-10", "x=0,y=0,z=-10", "x=0,y=0,z=-10",
      "x=0,y=0,z=-10", "x=0,y=0,z=-10", "x=0,y=0,z=-10", "x=0,y=0,z=-10",
      "x=0,y=0,z=-10", "x=0,y=0,z=-10", "x=0,y=0,z=-10", "x=0,y=0,z=-10",
      "x=0,y=0,z=-10", "x=0,y=0,z=-10", "x=0,y=0,z=-10"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_10073),
    c("x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10073),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10073),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10073),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10073)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_deg = 400
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12076 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 400, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_deg': Element 1 is not <= 360."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_deg = -400
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19066 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = -400, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19066[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_deg': Element 1 is not >= -360."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19066[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_deg = c(45, -45)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16117 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = c(45, -45), suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_deg', 'y_deg', and 'z_deg' must all have the same length but had lengths: 1, 1, 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_deg = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13795 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = "hej", suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_deg': Must be of type 'numeric', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_deg = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14357 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = NA, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14357[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_deg': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14357[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: z_deg = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10374 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = NULL, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10374[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_deg': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10374[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: suffix = "_rotated"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19735 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "_rotated", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19735),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19735[["x_rotated"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_19735[["y_rotated"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19735[["z_rotated"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_19735[[".degrees_str"]],
    c("x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19735),
    c("x_rotated", "y_rotated", "z_rotated", ".origin", ".degrees",
      ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19735),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19735),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19735),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19735)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: suffix = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14317 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = NA, origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19575 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = NULL, origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19575[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19575[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: suffix, keep_original
  xpectr::set_test_seed(42)
  # Assigning output
  output_18877 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "_rotated", origin = c(0, 0, 0), origin_fn = NULL, keep_original = TRUE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18877),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18877[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_18877[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_18877[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_18877[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_18877[["x_rotated"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_18877[["y_rotated"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_18877[["z_rotated"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_18877[[".degrees_str"]],
    c("x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_18877),
    c("x", "y", "z", "g", "x_rotated", "y_rotated", "z_rotated", ".origin",
      ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18877),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18877),
    c("double", "double", "double", "double", "double", "double", "double",
      "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18877),
    c(15L, 10L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18877)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin = c(0.3, -0.3,...
  xpectr::set_test_seed(42)
  # Assigning output
  output_16399 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0.3, -0.3, 0.5), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16399),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16399[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_16399[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_16399[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_16399[[".degrees_str"]],
    c("x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_16399),
    c("x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16399),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16399),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16399),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16399)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19709 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = 0, origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19709[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 3, but has length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19709[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin = "h"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16188 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = "h", origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16188[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must be of type 'numeric' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16188[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin = c(NA, 1, 0.4)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13334 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(NA, 1, 0.4), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13334[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13334[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin = c(NA, NA, NA)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13467 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(NA, NA, NA), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13467[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13467[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13984 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = NA, origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13984[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 3, but has length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13984[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17846 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = NULL, origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_17846[['error']]),
    xpectr::strip("1 assertions failed:\n * At least one of {'origin', 'origin_fn'} must be specified (not 'NULL')."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17846[['error_class']]),
    xpectr::strip(c(purrr_error, "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin_fn = centroid
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10389 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10389[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10389[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_10389 <- xpectr::suppress_mw(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = centroid, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_10389),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10389[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_10389[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_10389[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_10389[[".degrees_str"]],
    c("x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_10389),
    c("x", "y", "z", ".origin", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10389),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10389),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10389),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10389)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17487 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_17487[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17487[['error_class']]),
    xpectr::strip(c(purrr_error, "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: degrees_col_name = "....
  xpectr::set_test_seed(42)
  # Assigning output
  output_16772 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".nooot", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16772),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16772[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_16772[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_16772[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_16772[[".nooot_str"]],
    c("x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_16772),
    c("x", "y", "z", ".origin", ".nooot", ".nooot_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16772),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16772),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16772),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16772)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: degrees_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11712 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = NA, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11712[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11712[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: degrees_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_12610 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = NULL, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_12610),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12610[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_12610[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_12610[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12610),
    c("x", "y", "z", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12610),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12610),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12610),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12610)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: degrees_col_name, ove...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15144 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = "g", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15144[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15144[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin_col_name = ".c...
  xpectr::set_test_seed(42)
  # Assigning output
  output_16756 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".centroid", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16756),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16756[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_16756[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_16756[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_16756[[".degrees_str"]],
    c("x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_16756),
    c("x", "y", "z", ".centroid", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16756),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16756),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16756),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16756)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19828 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19828[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19828[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_17595 <- rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17595),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17595[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_17595[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17595[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_17595[[".degrees_str"]],
    c("x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0", "x=0,y=0,z=0",
      "x=0,y=0,z=0", "x=0,y=0,z=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17595),
    c("x", "y", "z", ".degrees", ".degrees_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17595),
    c("numeric", "numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17595),
    c("double", "double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17595),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17595)),
    character(0),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15664 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_15664[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: x, y, z."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15664[['error_class']]),
    xpectr::strip(c(purrr_error, "error", "condition")),
    fixed = TRUE)

  # Testing rotate_3d(data = df, x_col = "x", y_col = "y...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18496 <- xpectr::capture_side_effects(rotate_3d(data = df, x_col = "x", y_col = "y", z_col = "z", x_deg = 0, y_deg = 0, z_deg = 0, suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18496[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18496[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'rotate_3d'                                             ####
  #
})
