% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrangers.R
\name{extreme_pairing_rearranger_}
\alias{extreme_pairing_rearranger_}
\title{Wrapper for running extreme pairing}
\usage{
extreme_pairing_rearranger_(
  data,
  col = NULL,
  unequal_method = "middle",
  shuffle_members = FALSE,
  shuffle_pairs = FALSE,
  num_pairings = 1,
  balance = "mean",
  factor_name = ".pair",
  overwrite = FALSE
)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{col}{Column to create sorting factor by. When \code{NULL} and \code{`data`} is a \code{data.frame},
the row numbers are used.}

\item{unequal_method}{Method for dealing with an unequal number of rows
in \code{`data`}.

One of: \code{first}, \code{middle} or \code{last}

\subsection{first}{
The first group will have size \code{1}.

\strong{Example}:

The ordered column values:

\code{c(1, 2, 3, 4, 5)}

Creates the \strong{sorting factor}:

\code{c(}\strong{\code{1}}\code{, 2, 3, 3, 2)}

And are \strong{ordered as}:

\code{c(}\strong{\code{1}}\code{, 2, 5, 3, 4)}

}

\subsection{middle}{
The middle group will have size \code{1}.

\strong{Example}:

The ordered column values:

\code{c(1, 2, 3, 4, 5)}

Creates the \strong{sorting factor}:

\code{c(1, 3, }\strong{\code{2}}\code{, 3, 1)}

And are \strong{ordered as}:

\code{c(1, 5, } \strong{\code{3}}\code{, 2, 4)}

}
\subsection{last}{
The last group will have size \code{1}.

\strong{Example}:

The ordered column values:

\code{c(1, 2, 3, 4, 5)}

Creates the \strong{sorting factor}:

\code{c(1, 2, 2, 1, }\strong{\code{3}}\code{)}

And are \strong{ordered as}:

\code{c(1, 4, 2, 3,} \strong{\code{5}}\code{)}

}}

\item{shuffle_members}{Whether to shuffle the pair members. (Logical)}

\item{shuffle_pairs}{Whether to shuffle the pairs. (Logical)}

\item{num_pairings}{Number of pairings to perform (recursively). At least \code{1}.

Based on \code{`balance`}, the secondary pairings perform extreme pairing on either the
\emph{sum}, \emph{absolute difference}, \emph{min}, or \emph{max} of the pair elements.}

\item{balance}{What to balance pairs for in a given \emph{secondary} pairing.
Either \code{"mean"}, \code{"spread"}, \code{"min"}, or \code{"max"}.
Can be a single string used for all secondary pairings
or one for each secondary pairing (\code{`num_pairings` - 1}).

The first pairing always pairs the actual element values.

\subsection{mean}{
Pairs have similar means. The values in the pairs from the previous pairing
are aggregated with \code{`sum()`} and paired.
}
\subsection{spread}{
Pairs have similar spread (e.g. standard deviations). The values in the pairs from the previous pairing
are aggregated with \code{`sum(abs(diff()))`} and paired.
}
\subsection{min / max}{
Pairs have similar minimum / maximum values. The values in the pairs from the previous pairing
are aggregated with \code{`min()`} / \code{`max()`} and paired.
}}

\item{factor_name}{Name of new column with the sorting factor. If \code{NULL}, no column is added.}

\item{overwrite}{Whether to allow overwriting of existing columns. (Logical)}
}
\value{
The sorted \code{data.frame} (\code{tibble}) / \code{vector}.
Optionally with the sorting factor(s) added.

When \code{`data`} is a \code{vector} and \code{`factor_name`} is \code{NULL},
the output will be a \code{vector}. Otherwise, a \code{data.frame}.
}
\description{
Wrapper for running extreme pairing
}
\keyword{internal}
