% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_functions.R
\name{mincontrast_st}
\alias{mincontrast_st}
\title{Minimum constrast spatio-temporal estimation}
\usage{
mincontrast_st(data, covariates, boundary, pop.var = "popdens")
}
\arguments{
\item{data}{A data frame consisting of columns \code{x}, \code{y}, and \code{t}, which are two
spatial coordinates and time point respectively.}

\item{covariates}{A \code{spatialPolygonsDataFrame} covering the area of interest with the
population density column named \code{popdens}}

\item{boundary}{A \code{spatialPolygonsDataFrame} of the boundary of the area of interest.}

\item{pop.var}{Name of the population density variable}
}
\value{
Returned values are the minimum contrast estimates of phi, sigma^2 and theta,
as well as the overall squared discrepancy between the parametric and nonparametric forms
of the spatial function used corresponding to these estimates.
}
\description{
A wrapper to the function \code{lgcp::minimum.contrast.spatiotemporal}
}
\details{
\code{mincontrast_st} provides a simplified wrapper to the
function \code{lgcp::minimum.contrast.spatiotemporal}. For more details see
\code{help(lgcp::minimum.contrast.spatiotemporal).}
}
