% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{rws_describe_meta.character}
\alias{rws_describe_meta.character}
\title{Add Descriptions to SQL Meta Data Table}
\usage{
\method{rws_describe_meta}{character}(x, column, description, ..., conn)
}
\arguments{
\item{x}{A character vector of table name(s).}

\item{column}{A character vector of column name(s).}

\item{description}{A character vector of the description(s)}

\item{...}{Not used.}

\item{conn}{A \linkS4class{SQLiteConnection} to a database.}
}
\value{
An invisible copy of the updated meta table.
}
\description{
Add Descriptions to SQL Meta Data Table
}
\examples{
conn <- rws_connect()
rws_write(rws_data, exists = FALSE, conn = conn)
rws_read_meta(conn)
rws_describe_meta("rws_data", "Units", "The site length.", conn = conn)
rws_describe_meta("rws_data", "POSIXct", "Time of the visit", conn = conn)
rws_read_meta(conn)
rws_disconnect(conn)
}
\seealso{
Other rws_describe_meta: 
\code{\link{rws_describe_meta}()}
}
\concept{rws_describe_meta}
