% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read.dta13}
\alias{read.dta13}
\title{Read Stata Binary Files}
\usage{
read.dta13(file, convert.factors = TRUE, generate.factors = FALSE,
  encoding = localeToCharset()[1], fromEncoding = NULL,
  convert.underscore = FALSE, missing.type = FALSE, convert.dates = TRUE,
  replace.strl = TRUE, add.rownames = FALSE, nonint.factors = FALSE)
}
\arguments{
\item{file}{\emph{character.} Path to the dta file you want to import.}

\item{convert.factors}{\emph{logical.} If \code{TRUE}, factors from Stata
value labels are created.}

\item{generate.factors}{\emph{logical.} If \code{TRUE} and convert.factors is
TRUE, missing factor labels are created from integers.}

\item{encoding}{\emph{character.} Strings can be converted from Windows-1252 or UTF-8
to system encoding. Options are "latin1" or "UTF-8" to specify target
encoding explicitly. Stata 14 files are UTF-8 encoded and may contain strings
 which can't be displayed in the current locale. 
 Set encoding=NULL to stop reencoding.}

\item{fromEncoding}{\emph{character.} We expect strings to be encoded as
"CP1252" for Stata Versions 13 and older. For dta files saved with Stata 14
or newer "UTF-8" is used. In some situation the used encoding can differ for
Stata 14 files and must be manually set.}

\item{convert.underscore}{\emph{logical.} If \code{TRUE}, "_" in variable
names will be changed to "."}

\item{missing.type}{\emph{logical.} Stata knows 27 different missing types:
., .a, .b, ..., .z. If \code{TRUE}, attribute \code{missing} will be
 created.}

\item{convert.dates}{\emph{logical.} If \code{TRUE}, Stata dates are
converted.}

\item{replace.strl}{\emph{logical.} If \code{TRUE}, replace the reference to
a strL string in the data.frame with the actual value. The strl attribute
will be removed from the data.frame (see details).}

\item{add.rownames}{\emph{logical.} If \code{TRUE}, the first column will be
used as rownames. Variable will be dropped afterwards.}

\item{nonint.factors}{\emph{logical.} If \code{TRUE}, factors labels 
will be assigned to variables of type float and double.}
}
\value{
The function returns a data.frame with attributes. The attributes
 include
\describe{
  \item{datalabel:}{Dataset label}
  \item{time.stamp:}{Timestamp of file creation}
  \item{formats:}{Stata display formats. May be used with
   \code{\link{sprintf}}}
  \item{types:}{Stata data type (see Stata Corp 2014)}
  \item{val.labels:}{For each variable the name of the associated value
   labels in "label"}
  \item{var.labels:}{Variable labels}
  \item{version:}{dta file format version}
  \item{label.table:}{List of value labels.}
  \item{strl:}{Character vector with long strings for the new strl string variable
   type. The name of every element is the identifier.}
  \item{expansion.fields:}{list providing variable name, characteristic name
   and the contents of Stata characteristic field.}
  \item{missing:}{List of numeric vectors with Stata missing type for each
   variable.}
}
}
\description{
\code{read.dta13} reads a Stata dta-file and imports the data into a
 data.frame.
}
\details{
If the filename is a url, the file will be downloaded as a temporary
 file and read afterwards.

Stata files are encoded in ansinew. Depending on your system's default encoding
 certain characters may appear wrong. Using a correct encoding may fix these.

Variable names stored in the dta-file will be used in the resulting
 data.frame. Stata types char, byte, and int will become integer; float and
 double will become numerics. R only knows a single missing type, while Stata
 knows 27, so all Stata missings will become NA in R.  If you need to keep
 track of Statas original missing types, you may use
 \code{missing.type=TRUE}.

Stata dates are converted to R's Date class the same way foreign handles
dates.

Stata 13 introduced a new character type called strL. strLs are able to store
 strings up to 2 billion characters.  While R is able to store
 strings of this size in a character vector, the printed representation of such 
 vectors looks rather cluttered, so it's possible to save only a reference in the 
 data.frame with option \code{replace.strl=FALSE}. 

In R, you may use rownames to store characters (see for instance
 \code{data(swiss)}). In Stata, this is not possible and rownames have to be
 stored as a variable. If you want to use rownames, set add.rownames to TRUE. 
 Then the first variable of the dta-file will hold the rownames of the resulting 
 data.frame.

Reading dta-files of older and newer versions than 13 was introduced 
 with version 0.8.
}
\note{
read.dta13 uses GPL 2 licensed code by Thomas Lumley and R-core members
 from foreign::read.dta().
}
\author{
Jan Marvin Garbuszus \email{jan.garbuszus@ruhr-uni-bochum.de}

Sebastian Jeworutzki \email{sebastian.jeworutzki@ruhr-uni-bochum.de}
}
\references{
Stata Corp (2014): Description of .dta file format
 \url{http://www.stata.com/help.cgi?dta}
}
\seealso{
\code{\link[foreign]{read.dta}} in package \code{foreign} and \code{memisc} for dta files from Stata
versions < 13 and \code{read_dta} in package \code{haven} for Stata version >= 13.
}

