% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_abs.R
\name{tidy_abs}
\alias{tidy_abs}
\title{Tidy ABS time series data.}
\usage{
tidy_abs(df, metadata = TRUE)
}
\arguments{
\item{df}{A data frame containing ABS time series data
that has been extracted using \code{extract_abs_sheets}.}

\item{metadata}{logical. If \code{TRUE} (the default), a tidy data frame
including ABS metadata (series name, table name, etc.) is
included in the output. If \code{FALSE}, metadata is dropped.}
}
\value{
data frame (tibble) in long format.
}
\description{
Tidy ABS time series data.
}
\examples{

# First extract the data from the local spreadsheet
\dontrun{
wpi <- extract_abs_sheets("634501.xls")
}

# Then tidy the data extracted from the spreadsheet. Note that
# \code{extract_abs_sheets()} returns a list of data frames, so we need to
# subset the list.
\dontrun{
tidy_wpi <- tidy_abs(wpi[[1]])
}

}
