% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex-readwrite.R
\name{writeGenalexExcel}
\alias{writeGenalexExcel}
\title{Write GenAlEx-format genotypes to an Excel worksheet}
\usage{
writeGenalexExcel(x, file, worksheet, na = c("0", "-1"), na.character = "",
  check.annotation = TRUE, overwrite = FALSE)
}
\arguments{
\item{x}{Annotated data frame of class \code{'genalex'}}

\item{file}{Excel workbook file to which to write the worksheet}

\item{worksheet}{Worksheet name in a format valid for Excel, see
\code{\link[XLConnect]{createSheet}}}

\item{na}{The string to use when writing missing values in genotype
data.  Defaults to \code{"0"}, and must be one of \code{"0"} or
\code{"-1"}, as allowed by GenAlEx.}

\item{na.character}{The string to use when writing missing values in
character data.  Defaults to \code{""}.}

\item{check.annotation}{If \code{TRUE}, the annotations for the dataset
are checked using \code{is.genalex(x, force = TRUE, skip.strings = TRUE)}.
If that returns \code{FALSE}, nothing is written and an error is generated.}

\item{overwrite}{If \code{FALSE}, an existing sheet with the same name as
\code{worksheet} will not be overwritten, if \code{TRUE} it will be.}
}
\value{
No value is returned.
}
\description{
Writes genotype data file in GenAlEx format from an annotated data frame
of class \code{'genalex'} to an Excel worksheet.  Both \code{.xls} and
\code{.xlsx} formats may be written.  This function uses the function
\code{\link[XLConnect]{writeWorksheet}} and others from the
\href{http://cran.r-project.org/web/packages/XLConnect/index.html}{XLConnect}
package to write the Excel file.  Strings representing \code{NA} values are
strictly those allowed by GenAlEx itself, 0 and -1.  The worksheet is
written using the default formatting of the \code{XLConnect} package.
}
\details{
Only the first column for each locus is given a heading, specifically the
locus name.  The other columns representing further alleles for the locus
are left blank.

Any extra columns of data, if present in the object of class
\code{'genalex'}, are written immediately to the right of the genotype
columns.

For further information and cautions, see \code{\link{writeGenalex}}.
}
\examples{
data(Qagr_adult_genotypes)
d <- head(Qagr_adult_genotypes)
## recalculate class attributes
d <- as.genalex(d, force = TRUE)
## create Excel worksheet, will not overwrite existing
writeGenalexExcel(d, "test.xlsx", "test")
}
\author{
Douglas G. Scofield
}
\references{
Peakall, R. and Smouse P.E. (2012) GenAlEx 6.5: genetic analysis
in Excel. Population genetic software for teaching and research-an update.
\emph{Bioinformatics} 28, 2537-2539.

Peakall, R. and Smouse P.E. (2006) GENALEX 6: genetic analysis in Excel.
Population genetic software for teaching and research. \emph{Molecular
Ecology Notes} 6, 288-295.
}
\seealso{
\code{\link{readGenalexExcel}}, \code{\link{writeGenalex}}, \code{\link[XLConnect]{writeWorksheet}} \code{\link[XLConnect]{createSheet}}
}
\keyword{attribute}
\keyword{file}
\keyword{manip}

