% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.reReg}
\alias{residuals.reReg}
\title{Calculate Residuals for a `reReg' Fit}
\usage{
\method{residuals}{reReg}(object, model = c("recurrent", "failure"), ...)
}
\arguments{
\item{object}{an object of class \code{reReg} returned by the \code{reReg()} function.}

\item{model}{a character string specifying whether the residuals will be calculated
under the recurrent event model or the failure time model.}

\item{...}{additional parameters for future development.}
}
\description{
Calculates residuals for a joint frailty scale-change model fitted by `reReg`.
Under the recurrent event model, at each observation time, \eqn{t},
the residual is calculated as
\deqn{\mbox{observed number of recurrent events at } t- 
\mbox{expected number of recurrent events at} t.}
The expected number of recurrent events at \eqn{t} is calculated by the
cumulative rate function at \eqn{t}.
Under the failure time model, the residual is calculated as
\deqn{\Delta - H(t),}
where \eqn{\Delta} is the terminal event indicator and
\eqn{H(t)} is the cumulative hazard function at \eqn{t}.
}
