% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_history.R
\name{drop_history}
\alias{drop_history}
\title{Obtains metadata for all available revisions of a file, including the current
revision.}
\usage{
drop_history(path, limit = 10, dtoken = get_dropbox_token())
}
\arguments{
\item{path}{path to a file in dropbox.}

\item{limit}{maximum number of revisions to return; defaults to 10.}

\item{dtoken}{The Dropbox token generated by \code{\link{drop_auth}}. rdrop2
will try to automatically locate your local credential cache and use them.
However, if the credentials are not found, the function will initiate a new
authentication request. You can override this in \code{\link{drop_auth}} by
pointing to a different location where your credentials are stored.}
}
\value{
\code{tbl_df} of metadata, one row per revision.
}
\description{
Does not include deleted revisions.
}
\examples{
\dontrun{
  write.csv(iris, file = "iris.csv")
  drop_upload("iris.csv")
  write.csv(iris[iris$Species == "setosa", ], file = "iris.csv")
  drop_upload("iris.csv")
  drop_history("iris.csv")
}

}
