% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caching.R
\name{dpla_cache}
\alias{dpla_cache}
\title{Caching}
\description{
Manage cached \code{rdpla} files with \pkg{hoardr}
}
\details{
The dafault cache directory is
\code{paste0(rappdirs::user_cache_dir(), "/R/rdpla")}, but you can set
your own path using \code{cache_path_set()}

\code{cache_delete} only accepts 1 file name, while
\code{cache_delete_all} doesn't accept any names, but deletes all files.
For deleting many specific files, use \code{cache_delete} in a \code{\link[=lapply]{lapply()}}
type call
}
\section{Useful user functions}{

\itemize{
\item \code{dpla_cache$cache_path_get()} get cache path
\item \code{dpla_cache$cache_path_set()} set cache path
\item \code{dpla_cache$list()} returns a character vector of full
path file names
\item \code{dpla_cache$files()} returns file objects with metadata
\item \code{dpla_cache$details()} returns files with details
\item \code{dpla_cache$delete()} delete specific files
\item \code{dpla_cache$delete_all()} delete all files, returns nothing
}
}

\examples{
\dontrun{
dpla_cache

# list files in cache
dpla_cache$list()

# delete certain database files
# dpla_cache$delete("file path")
# dpla_cache$list()

# delete all files in cache
# dpla_cache$delete_all()
# dpla_cache$list()

# set a different cache path from the default
}
}
