% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subdiv.R
\docType{methods}
\name{subdiv}
\alias{subdiv}
\alias{subdiv,powermean-method}
\alias{subdiv,relativeentropy-method}
\alias{subdiv,metacommunity-method}
\title{Calculate subcommunity-level diversity}
\usage{
subdiv(data, qs)

\S4method{subdiv}{powermean}(data, qs)

\S4method{subdiv}{relativeentropy}(data, qs)

\S4method{subdiv}{metacommunity}(data, qs)
}
\arguments{
\item{data}{\code{matrix} of mode \code{numeric}; containing diversity
components.}

\item{qs}{\code{vector} of mode \code{numeric}; parameter of conservatism.}
}
\value{
Returns a standard output of class \code{tibble}, with columns:
\itemize{
\item\code{measure}: raw or normalised, alpha, beta, rho, or gamma
\item\code{q}: parameter of conservatism
\item\code{type_level}: "subcommunity"
\item\code{type_name}: label attributed to type
\item\code{partition_level}: level of diversity, \emph{i.e.} subcommunity
\item\code{partition_name}: label attributed to partition
\item\code{diversity}: calculated subcommunity diversity
}


}
\description{
Generic function for calculating subcommunity-level diversity.
}
\details{
\code{data} may be input as one of three different classes:
\itemize{
\item{\code{powermean}: raw or normalised metacomunity alpha, rho or gamma 
diversity components; will calculate subcommunity-level raw or normalised 
metacomunity alpha, rho or gamma diversity}
\item{\code{relativeentropy}: raw or normalised metacommunity beta
diversity components; will calculate subcommunity-level raw or normalised 
metacommunity beta diversity}
\item{\code{metacommunity}: will calculate all subcommunity measures of 
diversity}
}
}
\examples{
# Define metacommunity
pop <- data.frame(a = c(1,3), b = c(1,1))
row.names(pop) <- paste0("sp", 1:2)
pop <- pop/sum(pop)
meta <- metacommunity(pop)

# Calculate subcommunity gamma diversity (takes the power mean)
g <- raw_gamma(meta)
subdiv(g, 0:2)

# Calculate subcommunity beta diversity (takes the relative entropy)
b <- raw_beta(meta)
subdiv(b, 0:2)

# Calculate all measures of subcommunity diversity
subdiv(meta, 0:2)

}
\references{
Reeve, R., T. Leinster, C. Cobbold, J. Thompson, N. Brummitt, 
S. Mitchell, and L. Matthews. 2016. How to partition diversity. 
arXiv 1404.6520v3:1–9.
}
