% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LabelService.R
\name{dfp_createLabels}
\alias{dfp_createLabels}
\title{LabelService}
\usage{
dfp_createLabels(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createLabelsResponse
}
\description{
Provides methods for the creation and management of Labels.
}
\details{
createLabels

Creates new Label objects.
}
\examples{
\dontrun{
request_data <- data.frame(name="Auto - Competitive Exclusion",
                           description=paste0("A label to prevent two different car ",
                                              "companies from showing ads together"),
                           types='COMPETITIVE_EXCLUSION')
request_data <- list('labels'=hypothetical_label)
result <- dfp_createLabels(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/LabelService#createLabels}{Google Documentation for createLabels}
}
