% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserService.R
\name{dfp_createUsers}
\alias{dfp_createUsers}
\title{UserService}
\usage{
dfp_createUsers(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createUsersResponse
}
\description{
Provides operations for creating, updating and retrieving User objects.
}
\details{
A user is assigned one of several different roles. Each Role type has a
unique ID that is used to identify that role in an organization. Role types
and their IDs can be retrieved by invoking #getAllRoles.

createUsers

Creates new User objects.
}
\examples{
\dontrun{
request_data <- data.frame(name = paste0("TestUser", 1:3),
                           email = paste0('testuser', 1:3, '@gmail.com'), 
                           roleId = rep(-1, 3))
result <- dfp_createUsers(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/UserService#createUsers}{Google Documentation for createUsers}
}
