% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomFieldService.R
\name{dfp_createCustomFields}
\alias{dfp_createCustomFields}
\title{createCustomFields}
\usage{
dfp_createCustomFields(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createCustomFieldsResponse
}
\description{
Creates new CustomField objects. The following fields are required: 
\itemize{
  \item{CustomField name}
  \item{CustomField entityType}
  \item{CustomField dataType}
  \item{CustomField visibility}
}
}
\examples{
\dontrun{
request_data <- data.frame(name='Timing',
                           description='The time that this creative runs.', 
                           entityType='CREATIVE',
                           dataType='DROP_DOWN',
                           visibility='FULL')
result <- dfp_createCustomFields(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/CustomFieldService#createCustomFields}{Google Documentation for createCustomFields}
}
