% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transition.R
\docType{class}
\name{Transition}
\alias{Transition}
\title{A transition in a semi-Markov model}
\description{
An R6 class representing a transition in a semi-Markov model.
}
\details{
A specialism of class \code{Arrow} which is used in a semi-Markov
model to represent a transition between two \code{MarkovState}s. The 
transition is optionally associated with a cost. The transition probability
is associated with the model (\code{SemiMarkovModel}) rather than the
transition.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super classes}{
\code{\link[rdecision:Edge]{rdecision::Edge}} -> \code{\link[rdecision:Arrow]{rdecision::Arrow}} -> \code{Transition}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Transition$new()}}
\item \href{#method-modvars}{\code{Transition$modvars()}}
\item \href{#method-set_cost}{\code{Transition$set_cost()}}
\item \href{#method-cost}{\code{Transition$cost()}}
\item \href{#method-clone}{\code{Transition$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="endpoints">}\href{../../rdecision/html/Edge.html#method-endpoints}{\code{rdecision::Edge$endpoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="is_same_edge">}\href{../../rdecision/html/Edge.html#method-is_same_edge}{\code{rdecision::Edge$is_same_edge()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="label">}\href{../../rdecision/html/Edge.html#method-label}{\code{rdecision::Edge$label()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="source">}\href{../../rdecision/html/Arrow.html#method-source}{\code{rdecision::Arrow$source()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Arrow" data-id="target">}\href{../../rdecision/html/Arrow.html#method-target}{\code{rdecision::Arrow$target()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of type \code{MarkovTransition}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Transition$new(source, target, cost = 0, label = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{\code{MarkovState} from which the transition starts.}

\item{\code{target}}{\code{MarkovState} to which the transition ends.}

\item{\code{cost}}{Cost associated with the transition.}

\item{\code{label}}{Character string containing a label for the transition (the
name of the event).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Transition} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Transition$modvars()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Find variables of type \code{ModVar} that have been 
specified as values associated with this \code{MarkovTransition}. 
Includes operands of these \code{ModVar}s, if they are expressions.
}

\subsection{Returns}{
A list of \code{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_cost"></a>}}
\if{latex}{\out{\hypertarget{method-set_cost}{}}}
\subsection{Method \code{set_cost()}}{
Set the cost associated with the transition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Transition$set_cost(c = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{c}}{Cost associated with the transition.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated \code{Transition} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cost"></a>}}
\if{latex}{\out{\hypertarget{method-cost}{}}}
\subsection{Method \code{cost()}}{
Return the cost associated with traversing the edge.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Transition$cost()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Cost.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Transition$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
