% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DecisionNode.R
\docType{class}
\name{DecisionNode}
\alias{DecisionNode}
\title{\verb{DecisionNode} class}
\description{
An R6 class for a decision node in a decision tree
}
\details{
A class to represent a decision node in a decision tree. The node
is associated with one or more branches to child nodes.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Node]{rdecision::Node}} -> \code{DecisionNode}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DecisionNode$new()}}
\item \href{#method-clone}{\code{DecisionNode$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Node" data-id="label">}\href{../../rdecision/html/Node.html#method-label}{\code{rdecision::Node$label()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Node" data-id="type">}\href{../../rdecision/html/Node.html#method-type}{\code{rdecision::Node$type()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new decision node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionNode$new(label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{A label for the node. Must be defined because the label is
used in tabulation of strategies. The label is automatically converted
to a syntactically valid (in R) name to ensure it can be used as a column
name in a data frame.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{DecisionNode} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DecisionNode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
