% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_type.R
\name{rd_type}
\alias{rd_type}
\title{Determine Type of Regression Discontinuity Design}
\usage{
rd_type(data, treat, assign_1, cutoff_1, operator_1 = NULL, assign_2 = NULL,
  cutoff_2 = NULL, operator_2 = NULL)
}
\arguments{
\item{data}{A \code{data.frame} with each row representing an observation.}

\item{treat}{The name of a numeric variable (treated = positive values).}

\item{assign_1}{The variable name of the primary assignment.}

\item{cutoff_1}{The cutoff value of the primary assignment.}

\item{operator_1}{The operator for the primary assignment.}

\item{assign_2}{The variable name of the secondary assignment.}

\item{cutoff_2}{The cutoff value of the secondary assignment.}

\item{operator_2}{The operator for the secondary assignment.}
}
\value{
A list of two elements:
\item{crosstab}{The cross-table as a data.frame.}
\item{type}{The type of design as a string.}
}
\description{
\code{rd_type} cross-tabulates observations based on (1) a binary treatment and 
(2) one or two assignments and their cutoff values.
}
