% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdataretriever.R
\name{install_msaccess}
\alias{install_msaccess}
\title{Install datasets via the Data Retriever.}
\usage{
install_msaccess(
  dataset,
  file = "access.mdb",
  table_name = "[{db} {table}]",
  debug = FALSE,
  use_cache = TRUE,
  force = FALSE,
  hash_value = NULL
)
}
\arguments{
\item{dataset}{the name of the dataset that you wish to install or path to a committed dataset zip file}

\item{file}{file name for database}

\item{table_name}{table name for installing of dataset}

\item{debug}{Setting TRUE helps in debugging in case of errors}

\item{use_cache}{Setting FALSE reinstalls scripts even if they are already installed}

\item{force}{Setting TRUE doesn't prompt for confirmation while installing committed datasets when changes are discovered in environment}

\item{hash_value}{the hash value of committed dataset when installing from provenance directory}
}
\description{
Data is stored in MSAccess database
}
\examples{
\donttest{
rdataretriever::install_msaccess(dataset = "iris", file = "sqlite.db")
}
}
