% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DisplayHEALPix.R
\name{displayPixels}
\alias{displayPixels}
\title{Display the pixels and grandchildren}
\usage{
displayPixels(boundary.j, j, plot.j = 5, spix, boundary.col = "gray",
  boundary.lwd = 1, incl.labels = 1:(12 * 4^boundary.j),
  col = "blue", size = 3)
}
\arguments{
\item{boundary.j}{The resolution to display boundaries at. If
this is missing then boundaries will not be plotted.}

\item{j}{The resolution that spix are specified at.}

\item{plot.j}{The resolution to plot grandchildren at}

\item{spix}{Integer vector. The pixel indices to display.
These must be in nested order.}

\item{boundary.col}{The boundary colour.}

\item{boundary.lwd}{The boundary line width.}

\item{incl.labels}{Integer vector of pixel indices to label at
resolution j.}

\item{col}{The colour to make the grandchildren.}

\item{size}{The size to make the grandchildren.}
}
\description{
Display the pixels spix at resolution \eqn{j} by colouring
in the grandchildren of spix at resolution \eqn{plot.j}
}
\examples{

## Example 1

## Plot base pixels 1,2,3 by colouring their grandchildren at resolution
## 5 (by default). No pixel boundaries.
displayPixels(j=0, spix=c(1,2,3))

## Plot base pixels 1,2,3 display and their boundaries (boundary.j=0)
displayPixels(0,0, spix=c(1,2,3))

## Plot base pixels 1,2,3 by colouring their grandchildren at resolution 2
displayPixels(0,0, plot.j = 2, spix=c(1,2,3))

## Example 2

demoNeighbours <- function(p,j) {
  neighbours(p, j)
  displayPixels(boundary.j = j, j = j, plot.j = 5,
                spix = neighbours(p, j),
                boundary.col = "gray",
                boundary.lwd = 1,
                incl.labels = neighbours(p, j),
                col = "blue",
                size = 3)
  rcosmo::displayPixelBoundaries(nside = 1, col = "blue", lwd = 3)
}

demoNeighbours(1,2)

}
