% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spearmanRho.r
\name{spearmanRho}
\alias{spearmanRho}
\title{Spearman's rho, Kendall's tau, Pearson's r}
\usage{
spearmanRho(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  method = "spearman",
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  reportIncomplete = FALSE,
  ...
)
}
\arguments{
\item{formula}{A formula indicating the two paired variables,
e.g.  \code{~ x + y}. The variables should be
vectors of the same length.}

\item{data}{The data frame to use.}

\item{x}{If no formula is given, the values for one variable.}

\item{y}{The values for the other variable.}

\item{method}{One of "spearman", "kendall", or "pearson".
Passed to \code{cor}.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{reportIncomplete}{If \code{FALSE} (the default),
\code{NA} will be reported in cases where there
are instances of the calculation of the statistic
failing during the bootstrap procedure.}

\item{...}{Additional arguments passed to the \code{cor} function.}
}
\value{
A single statistic, rho, tau, or r.
        Or a small data frame consisting of rho, tau, or r, 
        and the lower and upper confidence limits.
}
\description{
Calculates Spearmans's rho, Kendall's tau, or Pearson's r
             with confidence intervals by bootstrap
}
\details{
This function is a wrapper for \code{stats::cor}
         with the addition of confidence intervals.
           
         The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{y}.
         
          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.

          When the returned statistic is close to -1 or close to 1,
          or with small sample size,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
data(Catbus)
spearmanRho( ~ Steps + Rating, data=Catbus)

}
\references{
\url{http://rcompanion.org/handbook/I_10.html}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{effect size}
