% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseDifferences.r
\name{pairwiseDifferences}
\alias{pairwiseDifferences}
\title{Pairwise differences for unreplicated CBD}
\usage{
pairwiseDifferences(x, g, plotit = FALSE, factorize = FALSE)
}
\arguments{
\item{x}{The vector of the response variable.}

\item{g}{The vector of the grouping variable.}

\item{plotit}{If \code{TRUE}, then produces bar plots of the differences.}

\item{factorize}{If \code{TRUE}, then adds a column to the output 
data frame consisting of the differences as
a factor variable. This output is added automatically if
\code{plotit = TRUE}.}
}
\value{
A data frame of the paired groups, the differences in
        their response variables,
        and optionally the differences expressed as a factor variable.
        If \code{plotit = TRUE}, then also produce one or more plots.
}
\description{
Calculates the differences in the response variable
             for each pair of levels of a grouping variable 
             in an unreplicated complete block design.
}
\details{
The main use of the function is to check the shape of the
         distribution of differences in responses for paired t-test,
         paired rank-sum test, Friedman test, or Quade test.

          The function assumes that the data frame is already ordered by
          the blocking variable, so that the first observation of Group 1
          is paired with the first observation of Group 2, and so on.
          
          The function assumes that the data are in complete block design.
          That is,
          for any level of the grouping variable in Group 1 there exists
          one paired value in Group 2, and so on.
}
\examples{
### Two-sample paired data example with bar plot
data(Pooh)
Pooh.diff = pairwiseDifferences(x = Pooh$Likert, 
                                g = Pooh$Time,
                                plotit = TRUE)

### Unreplicated complete block design example with bar plots
data(BobBelcher)
Bob.diff = pairwiseDifferences(x= BobBelcher$Likert, 
                               g=BobBelcher$Instructor, 
                               factorize=TRUE)
library(lattice)
histogram(~ Difference.f | Comparison,
         data=Bob.diff,
         type = "count",
         layout=c(2,5))

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/F_10.html}
}
\concept{
paired t-test rank-sum friedman quade histogram
}

