% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climate_data.R
\name{ec_climate_long}
\alias{ec_climate_long}
\title{Transform EC Climate Data to Parameter-Long Form}
\usage{
ec_climate_long(climate_df, na.rm = FALSE)
}
\arguments{
\item{climate_df}{The outuput of \link{ec_climate_data}}

\item{na.rm}{TRUE to remove measurements for which there is no information}
}
\value{
A data.frame (tibble) with one row per measurement
}
\description{
Transform EC Climate Data to Parameter-Long Form
}
\examples{
\donttest{
# station 27141 is Kentville CDA CS
monthly <- ec_climate_data(27141, timeframe = "monthly")
ec_climate_long(monthly)

# or use the pipe
ec_climate_data(27141, timeframe = "monthly") \%>\%
  ec_climate_long()
}

}
